/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.environment;

import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestEnvironmentInputFilter
extends DefaultFileTypeSpecificInputFilter {
    private static final String[] ENV_FILE_NAMES = new String[]{"rest-client.env.json", "http-client.env.json"};
    public static final String[] ENV_PRIVATE_FILE_NAMES = new String[]{"rest-client.private.env.json", "http-client.private.env.json"};

    public HttpRequestEnvironmentInputFilter() {
        super(new FileType[]{JsonFileType.INSTANCE});
    }

    public static boolean isHttpRequestEnvFile(@Nullable VirtualFile file) {
        if (file != null) {
            String fileName = file.getName();
            return ArrayUtil.contains((String)fileName, (String[])ENV_FILE_NAMES) || HttpRequestEnvironmentInputFilter.isPrivateEnvFile(fileName);
        }
        return false;
    }

    public boolean acceptInput(@NotNull VirtualFile file) {
        if (file == null) {
            HttpRequestEnvironmentInputFilter.$$$reportNull$$$0(0);
        }
        return super.acceptInput(file) && HttpRequestEnvironmentInputFilter.isHttpRequestEnvFile(file);
    }

    public static boolean isPrivateEnvFile(@NotNull String fileName) {
        if (fileName == null) {
            HttpRequestEnvironmentInputFilter.$$$reportNull$$$0(1);
        }
        return ArrayUtil.contains((String)fileName, (String[])ENV_PRIVATE_FILE_NAMES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/environment/HttpRequestEnvironmentInputFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptInput";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrivateEnvFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

