/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.PerforceCachingContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceContentRevision;
import org.jetbrains.idea.perforce.perforce.ResolvedFile;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class ChangeCreator {
    private final Project myProject;
    final Set<VirtualFile> reportedChanges = ContainerUtil.newHashSet();

    public ChangeCreator(Project project) {
        this.myProject = project;
    }

    public Change createEditedFileChange(FilePath path, long haveRevision, boolean isResolvedWithConflict) {
        return this.createChange(PerforceCachingContentRevision.create(this.myProject, path, haveRevision), CurrentContentRevision.create((FilePath)path), isResolvedWithConflict ? FileStatus.MERGED_WITH_CONFLICTS : FileStatus.MODIFIED);
    }

    public Change createAddedFileChange(FilePath path, boolean isResolvedWithConflict) {
        return this.createChange(null, CurrentContentRevision.create((FilePath)path), isResolvedWithConflict ? FileStatus.MERGED_WITH_CONFLICTS : FileStatus.ADDED);
    }

    /*
     * WARNING - void declaration
     */
    public Change createDeletedFileChange(@NotNull File file, long haveRevision, boolean bl) {
        void isResolvedWithConflict;
        if (file == null) {
            ChangeCreator.$$$reportNull$$$0(0);
        }
        return this.createChange(PerforceCachingContentRevision.create(this.myProject, VcsUtil.getFilePath((File)file, (boolean)false), haveRevision), null, isResolvedWithConflict != false ? FileStatus.MERGED_WITH_CONFLICTS : FileStatus.DELETED);
    }

    public Change createRenameChange(@NotNull P4Connection connection, ResolvedFile resolvedFile, FilePath afterPath) {
        long revision;
        if (connection == null) {
            ChangeCreator.$$$reportNull$$$0(1);
        }
        if ((revision = resolvedFile.getRevision2()) < 0L) {
            revision = resolvedFile.getRevision1();
        }
        PerforceContentRevision beforeRevision = PerforceContentRevision.create(this.myProject, connection, resolvedFile.getDepotPath(), revision, -1L);
        ContentRevision afterRevision = CurrentContentRevision.create((FilePath)afterPath);
        return this.createChange((ContentRevision)beforeRevision, afterRevision, FileStatus.MODIFIED);
    }

    private Change createChange(@Nullable ContentRevision before, @Nullable ContentRevision after, FileStatus fileStatus) {
        Change change = new Change(before, after, fileStatus);
        if (after != null) {
            ContainerUtil.addIfNotNull(this.reportedChanges, (Object)after.getFile().getVirtualFile());
        }
        if (before != null) {
            ContainerUtil.addIfNotNull(this.reportedChanges, (Object)before.getFile().getVirtualFile());
        }
        return change;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/application/ChangeCreator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDeletedFileChange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenameChange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

