/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.ui;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService;
import com.intellij.lang.javascript.linter.tslint.ui.TsLintView;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TsLintConfigurable
extends JSLinterConfigurable<TsLintState> {
    @NonNls
    public static final String SETTINGS_JAVA_SCRIPT_LINTERS_TSLINT = "settings.javascript.linters.tslint";

    public TsLintConfigurable(@NotNull Project project) {
        if (project == null) {
            TsLintConfigurable.$$$reportNull$$$0(0);
        }
        super(project, TsLintConfiguration.class, false);
    }

    public TsLintConfigurable(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            TsLintConfigurable.$$$reportNull$$$0(1);
        }
        super(project, TsLintConfiguration.class, fullModeDialog);
    }

    @NotNull
    protected JSLinterBaseView<TsLintState> createView() {
        TsLintView tsLintView = new TsLintView(this.getProject(), this.isFullModeDialog());
        if (tsLintView == null) {
            TsLintConfigurable.$$$reportNull$$$0(2);
        }
        return tsLintView;
    }

    @NotNull
    public String getId() {
        if (SETTINGS_JAVA_SCRIPT_LINTERS_TSLINT == null) {
            TsLintConfigurable.$$$reportNull$$$0(3);
        }
        return SETTINGS_JAVA_SCRIPT_LINTERS_TSLINT;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"settings.javascript.linters.tslint.configurable.name", (Object[])new Object[0]);
    }

    public void apply() throws ConfigurationException {
        super.apply();
        TsLintState state = (TsLintState)this.getExtendedState(TsLintConfiguration.class).getState();
        if (!StringUtil.isEmptyOrSpaces((String)state.getPackagePath()) && state.isAllowJs() && !TsLintConfigurable.checkPackageVersionForJs(state.getPackagePath())) {
            throw new ConfigurationException("Linting JavaScript is not supported for this version of TSLint.");
        }
        TsLintLanguageService service = TsLintLanguageService.getService(this.myProject);
        service.terminateStartedProcess(false);
    }

    private static boolean checkPackageVersionForJs(String packagePath) {
        VirtualFile packageJson;
        VirtualFile packageVf = LocalFileSystem.getInstance().findFileByPath(packagePath);
        if (packageVf != null && (packageJson = packageVf.findChild("package.json")) != null) {
            PackageJsonData data = PackageJsonUtil.getOrCreateData((VirtualFile)packageJson);
            return data.getVersion() != null && data.getVersion().getMajor() >= 4;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/ui/TsLintConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/ui/TsLintConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

