/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.commandLine;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.interpreters.PhpConfigurationOptionData;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.debug.PhpProjectDebugConfiguration;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.run.PhpRunUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCommandSettingsBuilder {
    private static final Function<PhpConfigurationOptionData, PhpConfigurationOption> CONFIGURATION_OPTION_ADAPTER = configurationOption -> new PhpConfigurationOption(configurationOption.getName(), configurationOption.getValue());
    public static final String INTERPRETER_NOT_FOUND_ERROR = PhpBundle.message("validation.value.is.not.specified.or.invalid", PhpBundle.message("interpreter", new Object[0]));
    @NotNull
    private final Project myProject;
    @Nullable
    private final PhpInterpreter myInterpreter;
    private boolean myLoadDebugExtension;
    private boolean myStartDebugger;

    public PhpCommandSettingsBuilder(@NotNull Project project, @NotNull PhpInterpreter interpreter) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(0);
        }
        if (interpreter == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(1);
        }
        this.myLoadDebugExtension = false;
        this.myStartDebugger = false;
        this.myProject = project;
        this.myInterpreter = interpreter;
    }

    public PhpCommandSettingsBuilder(@NotNull Project project) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(2);
        }
        this.myLoadDebugExtension = false;
        this.myStartDebugger = false;
        this.myProject = project;
        this.myInterpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
    }

    @NotNull
    public PhpCommandSettingsBuilder loadDebugExtension() {
        this.myLoadDebugExtension = true;
        PhpCommandSettingsBuilder phpCommandSettingsBuilder = this;
        if (phpCommandSettingsBuilder == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(3);
        }
        return phpCommandSettingsBuilder;
    }

    @NotNull
    public PhpCommandSettingsBuilder loadAndStartDebug(boolean startDebugger) {
        this.myLoadDebugExtension = startDebugger;
        this.myStartDebugger = startDebugger;
        PhpCommandSettingsBuilder phpCommandSettingsBuilder = this;
        if (phpCommandSettingsBuilder == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(4);
        }
        return phpCommandSettingsBuilder;
    }

    @NotNull
    public PhpCommandSettingsBuilder loadAndStartDebug() {
        PhpCommandSettingsBuilder phpCommandSettingsBuilder = this.loadAndStartDebug(true);
        if (phpCommandSettingsBuilder == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(5);
        }
        return phpCommandSettingsBuilder;
    }

    @NotNull
    public PhpCommandSettings build() throws ExecutionException {
        PhpCommandSettings command;
        if (this.myInterpreter == null) {
            throw new ExecutionException(INTERPRETER_NOT_FOUND_ERROR);
        }
        if (this.myInterpreter.isRemote()) {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager == null) {
                throw new ExecutionException("Remote interpreter can't be executed. Please enable the PHP Remote Interpreter plugin.");
            }
            command = manager.createPhpCommand(this.myProject, this.myInterpreter.getPhpSdkAdditionalData());
        } else {
            PhpCommandLinePathProcessor pathProcessor = PhpCommandLinePathProcessor.LOCAL;
            String path = pathProcessor.process(PhpCommandSettingsBuilder.findPhpBinary(this.myInterpreter.getHomePath()).getPath());
            command = PhpCommandSettingsBuilder.create(path, pathProcessor, null);
        }
        if (this.myLoadDebugExtension && StringUtil.isNotEmpty((String)this.myInterpreter.getDebuggerId())) {
            PhpProjectDebugConfiguration.State configuration;
            String extension = this.myInterpreter.getDebuggerExtension();
            if (StringUtil.isNotEmpty((String)extension)) {
                command.addOption(PhpConfigurationOption.createZendExtensionOption(extension).getText());
            }
            if (this.myStartDebugger && (configuration = PhpProjectDebugConfiguration.getInstance(this.myProject).getState()) != null && configuration.isLocalPassConfigurationOptions()) {
                PhpDebugExtension debugExtension = PhpDebugUtil.getDebugExtensionByDebuggerId(this.myInterpreter.getDebuggerId());
                String remoteHost = null;
                if (this.myInterpreter.isRemote()) {
                    PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                    if (manager == null) {
                        throw new ExecutionException("Remote interpreter can't be executed. Please enable the PHP Remote Interpreter plugin.");
                    }
                    remoteHost = manager.getRemoteHost(this.myProject, this.myInterpreter.getName(), this.myInterpreter.getPhpSdkAdditionalData());
                }
                remoteHost = StringUtil.notNullize(remoteHost, (String)"127.0.0.1");
                command.addConfigurationOptions(debugExtension.getDebugConfigurationsOptions(this.myProject, remoteHost));
            }
        }
        command.addConfigurationOptions(ContainerUtil.map(this.myInterpreter.getConfigurationOptions(), CONFIGURATION_OPTION_ADAPTER));
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(6);
        }
        return phpCommandSettings;
    }

    @Nullable
    public static String validate(@NotNull Project project) {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(7);
        }
        try {
            PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
            if (interpreter == null) {
                return INTERPRETER_NOT_FOUND_ERROR;
            }
            PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
            String validate = data.validate(project, null);
            if (StringUtil.isNotEmpty((String)validate)) {
                return validate;
            }
            if (!interpreter.isRemote()) {
                PhpCommandSettingsBuilder.findPhpBinary(interpreter.getHomePath());
            }
        }
        catch (ExecutionException e) {
            return e.getMessage();
        }
        return null;
    }

    public static PhpCommandSettings create(@NotNull String pathToBinary, @NotNull PhpCommandLinePathProcessor pathProcessor, @Nullable PhpSdkAdditionalData data) {
        if (pathToBinary == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(8);
        }
        if (pathProcessor == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(9);
        }
        return new PhpCommandSettings(pathToBinary, pathProcessor, data);
    }

    @NotNull
    public static PhpCommandSettings create(@NotNull Project project, boolean withDebuggerOptions) throws ExecutionException {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(10);
        }
        PhpCommandSettings phpCommandSettings = new PhpCommandSettingsBuilder(project).loadAndStartDebug(withDebuggerOptions).build();
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(11);
        }
        return phpCommandSettings;
    }

    @NotNull
    public static PhpCommandSettings create(@NotNull Project project, @NotNull PhpInterpreter interpreter, boolean withDebuggerOptions) throws ExecutionException {
        if (project == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(12);
        }
        if (interpreter == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(13);
        }
        PhpCommandSettings phpCommandSettings = new PhpCommandSettingsBuilder(project, interpreter).loadAndStartDebug(withDebuggerOptions).build();
        if (phpCommandSettings == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(14);
        }
        return phpCommandSettings;
    }

    @NotNull
    public static VirtualFile findPhpBinary(@Nullable String phpHome) throws ExecutionException {
        VirtualFile binary = PhpRunUtil.findFileOrDirectory(phpHome, false);
        if (binary == null) {
            throw new ExecutionException(PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP home"));
        }
        if (binary.isDirectory()) {
            String phpExecutableName = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
            VirtualFile executable = binary.findChild(phpExecutableName);
            if (executable == null) {
                throw new ExecutionException(PhpBundle.message("validation.0.not.found.at.1", phpExecutableName, binary.getPresentableUrl()));
            }
            if (executable.isDirectory()) {
                throw new ExecutionException(PhpBundle.message("validation.0.is.not.a.directory", executable.getPresentableUrl()));
            }
            VirtualFile virtualFile = executable;
            if (virtualFile == null) {
                PhpCommandSettingsBuilder.$$$reportNull$$$0(15);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = binary;
        if (virtualFile == null) {
            PhpCommandSettingsBuilder.$$$reportNull$$$0(16);
        }
        return virtualFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/commandLine/PhpCommandSettingsBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBinary";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/commandLine/PhpCommandSettingsBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDebugExtension";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAndStartDebug";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findPhpBinary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

