/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.debug.TypeInfo;
import com.jetbrains.php.debug.common.PhpCompactValuePresentation;
import com.jetbrains.php.debug.common.PhpEvaluationResultProcessor;
import com.jetbrains.php.debug.common.PhpRuntimeVariable;
import com.jetbrains.php.debug.common.PhpValue;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpNavigatableValue
extends PhpValue
implements PhpRuntimeVariable {
    @Nullable
    private PhpType myCachedVariableType;

    @Override
    @NotNull
    protected XValuePresentation defaultPresentation(@NotNull String value, @Nullable String type) {
        if (value == null) {
            PhpNavigatableValue.$$$reportNull$$$0(0);
        }
        PhpCompactValuePresentation phpCompactValuePresentation = new PhpCompactValuePresentation(value, type);
        if (phpCompactValuePresentation == null) {
            PhpNavigatableValue.$$$reportNull$$$0(1);
        }
        return phpCompactValuePresentation;
    }

    @Nullable
    protected PsiElement findTargetField(@NotNull Project project, @NotNull XSourcePosition position, @NotNull Editor editor, @NotNull String name) {
        PsiFile file;
        if (project == null) {
            PhpNavigatableValue.$$$reportNull$$$0(2);
        }
        if (position == null) {
            PhpNavigatableValue.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            PhpNavigatableValue.$$$reportNull$$$0(4);
        }
        if (name == null) {
            PhpNavigatableValue.$$$reportNull$$$0(5);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null && file.getVirtualFile().equals(position.getFile())) {
            ASTNode leafElement = file.getNode().findLeafElementAt(position.getOffset());
            if (leafElement == null) {
                return null;
            }
            PhpClass clazz = (PhpClass)PhpPsiUtil.getParentByCondition(leafElement.getPsi(), (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (clazz == null) {
                return null;
            }
            return DumbService.isDumb((Project)project) ? null : clazz.findFieldByName((CharSequence)name, false);
        }
        return null;
    }

    @Nullable
    public abstract Map<String, String> getLoadedChildren();

    @NotNull
    public abstract String getPresentableValue();

    protected abstract boolean isArray();

    protected abstract boolean isObject();

    protected abstract List<String> getChildren(int var1);

    protected abstract int getChildrenCount();

    protected abstract XDebugSession getSession();

    public abstract String getShortName();

    @Override
    @NotNull
    public synchronized PhpType getType() {
        if (this.myCachedVariableType == null) {
            this.myCachedVariableType = this.calculateType();
        }
        PhpType phpType = this.myCachedVariableType;
        if (phpType == null) {
            PhpNavigatableValue.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    @NotNull
    protected abstract PhpType calculateType();

    public abstract void processFullValue(@NotNull PhpEvaluationResultProcessor var1);

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            PhpNavigatableValue.$$$reportNull$$$0(7);
        }
        this.computeSourcePosition(navigatable, false);
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable, boolean computeNearest) {
        if (navigatable == null) {
            PhpNavigatableValue.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            XStackFrame stackFrame;
            XDebugSession debugSession;
            if (navigatable == null) {
                PhpNavigatableValue.$$$reportNull$$$0(23);
            }
            if ((debugSession = this.getSession()) != null && (stackFrame = debugSession.getCurrentStackFrame()) != null) {
                PsiElement resolved;
                Project project = debugSession.getProject();
                XSourcePosition position = debugSession.getCurrentPosition();
                Editor editor = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)project)).getSelectedTextEditor(true);
                if (editor != null && position != null && (resolved = this.findTargetElement(project, position, editor)) != null) {
                    VirtualFile virtualFile = resolved.getContainingFile().getVirtualFile();
                    navigatable.setSourcePosition(XDebuggerUtil.getInstance().createPositionByOffset(virtualFile, resolved.getTextOffset()));
                    if (computeNearest) {
                        navigatable.setSourcePosition(this.findNearestPosition(resolved));
                    }
                    return;
                }
            }
            navigatable.setSourcePosition(null);
        });
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(final @NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            PhpNavigatableValue.$$$reportNull$$$0(9);
        }
        this.computeSourcePosition(new XNavigatable(){

            public void setSourcePosition(@Nullable XSourcePosition sourcePosition) {
                callback.computed(sourcePosition);
            }
        }, true);
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            PhpNavigatableValue.$$$reportNull$$$0(10);
        }
        return threeState;
    }

    @Nullable
    protected abstract PsiElement findTargetElement(@NotNull Project var1, @NotNull XSourcePosition var2, @NotNull Editor var3);

    @Nullable
    protected PsiElement findTargetVariable(@NotNull Project project, @NotNull XSourcePosition position, @NotNull Editor editor, @NotNull String name) {
        PsiFile file;
        if (project == null) {
            PhpNavigatableValue.$$$reportNull$$$0(11);
        }
        if (position == null) {
            PhpNavigatableValue.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            PhpNavigatableValue.$$$reportNull$$$0(13);
        }
        if (name == null) {
            PhpNavigatableValue.$$$reportNull$$$0(14);
        }
        if ((file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null && file.getVirtualFile().equals(position.getFile())) {
            Set<? extends PhpNamedElement> decl;
            ASTNode leafElement = file.getNode().findLeafElementAt(position.getOffset());
            if (leafElement == null) {
                return null;
            }
            PhpScopeHolder holder = PhpPsiUtil.getScopeHolder(leafElement.getPsi());
            if (holder != null && !(decl = VariableImpl.collectDeclarationsByScope((PsiElement)holder, false, StringUtil.trimStart((String)name, (String)"$"))).isEmpty()) {
                return (PsiElement)decl.iterator().next();
            }
        }
        return null;
    }

    @NotNull
    protected String wrapPresentableValue(@NotNull TypeInfo typeInfo, @NotNull String value) {
        if (typeInfo == null) {
            PhpNavigatableValue.$$$reportNull$$$0(15);
        }
        if (value == null) {
            PhpNavigatableValue.$$$reportNull$$$0(16);
        }
        String string = typeInfo.isString() ? "\"" + value + "\"" : value;
        if (string == null) {
            PhpNavigatableValue.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    private XSourcePosition findNearestPosition(@NotNull PsiElement element) {
        XDebugSession debugSession;
        if (element == null) {
            PhpNavigatableValue.$$$reportNull$$$0(18);
        }
        if ((debugSession = this.getSession()) != null) {
            PsiFile file;
            XSourcePosition position = debugSession.getCurrentPosition();
            Project project = element.getProject();
            Editor editor = ((FileEditorManagerImpl)FileEditorManager.getInstance((Project)project)).getSelectedTextEditor(true);
            if (editor != null && position != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null && file.isValid() && file.getVirtualFile().equals(position.getFile()) && !DumbService.isDumb((Project)project)) {
                Collection ranges = IdentifierHighlighterPass.getUsages((PsiElement)element, (PsiElement)file, (boolean)false);
                int breakPointLine = position.getLine();
                int bestLine = -1;
                boolean hasSameLine = false;
                TextRange declaration = element.getTextRange();
                for (TextRange range : ranges) {
                    if (declaration.intersects(range)) continue;
                    int line = editor.offsetToLogicalPosition((int)range.getStartOffset()).line;
                    if (line > bestLine && line < breakPointLine) {
                        bestLine = line;
                        continue;
                    }
                    if (line != breakPointLine) continue;
                    hasSameLine = true;
                }
                if (bestLine > -1) {
                    int nearestLine = hasSameLine ? breakPointLine : bestLine;
                    return XDebuggerUtil.getInstance().createPosition(file.getVirtualFile(), nearestLine);
                }
            }
        }
        return null;
    }

    public boolean canNavigateToTypeSource() {
        Set types = this.getType().getTypes();
        return types.size() == 1 && !PhpType.isPrimitiveType((String)((String)types.iterator().next()));
    }

    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            PhpNavigatableValue.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Set types;
            if (navigatable == null) {
                PhpNavigatableValue.$$$reportNull$$$0(22);
            }
            if ((types = this.getType().getTypes()).size() != 1) {
                navigatable.setSourcePosition(null);
                return;
            }
            String type = (String)types.iterator().next();
            if (PhpType.isPrimitiveType((String)type)) {
                navigatable.setSourcePosition(null);
                return;
            }
            XDebugSession debugSession = this.getSession();
            if (debugSession != null) {
                Project project = debugSession.getProject();
                XSourcePosition position = debugSession.getTopFramePosition();
                PhpClass clazz = PhpNavigatableValue.findClosestClass(project, PhpLangUtil.toFQN(type), position != null ? position.getFile() : null);
                if (clazz != null) {
                    VirtualFile file = clazz.getContainingFile().getVirtualFile();
                    int offset = clazz.getTextOffset();
                    navigatable.setSourcePosition(XDebuggerUtil.getInstance().createPositionByOffset(file, offset));
                }
            }
        });
    }

    @Nullable
    private static PhpClass findClosestClass(@NotNull Project project, @NotNull String fqn, @Nullable VirtualFile currentFile) {
        Optional<PhpClass> inModule;
        Optional<PhpClass> inContentRoot;
        Collection classes;
        if (project == null) {
            PhpNavigatableValue.$$$reportNull$$$0(20);
        }
        if (fqn == null) {
            PhpNavigatableValue.$$$reportNull$$$0(21);
        }
        if ((classes = PhpIndex.getInstance((Project)project).getClassesByFQN(fqn)).isEmpty()) {
            return null;
        }
        if (currentFile == null) {
            return (PhpClass)classes.iterator().next();
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile root = fileIndex.getContentRootForFile(currentFile);
        if (root != null && (inContentRoot = classes.stream().filter(clazz -> root.equals(fileIndex.getContentRootForFile(clazz.getContainingFile().getVirtualFile()))).findAny()).isPresent()) {
            return inContentRoot.get();
        }
        Module module = fileIndex.getModuleForFile(currentFile);
        if (module != null && (inModule = classes.stream().filter(clazz -> module.equals(fileIndex.getModuleForFile(clazz.getContainingFile().getVirtualFile()))).findAny()).isPresent()) {
            return inModule.get();
        }
        return (PhpClass)classes.iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/common/PhpNavigatableValue";
                break;
            }
            case 2: 
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 8: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/common/PhpNavigatableValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInlineDebuggerData";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapPresentableValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "defaultPresentation";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 17: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTargetField";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeInlineDebuggerData";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findTargetVariable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "wrapPresentableValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findNearestPosition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeSourcePosition";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findClosestClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeTypeSourcePosition$1";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeSourcePosition$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

