/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.xdebug.dbgp.messages;

import com.intellij.openapi.util.text.StringUtilRt;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpInputMessage;
import com.jetbrains.php.debug.xdebug.dbgp.messages.DbgpResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PropertyValueResponse
extends DbgpResponse {
    private int mySize;
    private byte[] myRawValue;

    @Override
    public DbgpInputMessage deserialize(Element packet) throws IOException {
        super.deserialize(packet);
        String encoding = packet.getAttributeValue("encoding");
        String rawValue = packet.getText();
        if (!"base64".equals(encoding)) {
            throw new IOException("Unsupported encoding" + encoding);
        }
        this.myRawValue = Base64.getDecoder().decode(rawValue);
        this.mySize = StringUtilRt.parseInt((String)packet.getAttributeValue("size"), (int)0);
        return this;
    }

    public int getSize() {
        return this.mySize;
    }

    public String getValue(@NotNull String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            PropertyValueResponse.$$$reportNull$$$0(0);
        }
        return new String(this.myRawValue, encoding);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/jetbrains/php/debug/xdebug/dbgp/messages/PropertyValueResponse", "getValue"));
    }
}

