/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.zend.messages;

import com.intellij.openapi.util.Pair;
import com.jetbrains.php.debug.zend.ZendDebugUtil;
import com.jetbrains.php.debug.zend.messages.ZendDebugResponse;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GetCallStackResponse
extends ZendDebugResponse {
    private ArrayList<StackFrame> myStackFrames;

    @Override
    public short getMessageId() {
        return 1034;
    }

    @Override
    public ZendDebugResponse deserialize(DataInputStream in) throws IOException {
        this.myRequestId = in.readInt();
        this.myStatus = 1;
        this.myStackFrames = new ArrayList();
        int stackDepth = in.readInt();
        for (int i = 0; i < stackDepth; ++i) {
            this.myStackFrames.add(new StackFrame().deserialize(in));
        }
        return this;
    }

    public List<StackFrame> getStackFrames() {
        return this.myStackFrames;
    }

    @Override
    protected void appendParameters(Map<String, String> parameters) {
        super.appendParameters(parameters);
        GetCallStackResponse.appendParameters(parameters, "depth", this.myStackFrames.size());
    }

    public static class StackFrame {
        private String myCallerFileName;
        private int myCallerLineNumber;
        private String myCallerFunctionName;
        private String myCalledFileName;
        private int myCalledLineNumber;
        private String myCalledFunctionName;
        private final List<Parameter> myParameters = new ArrayList<Parameter>();

        public StackFrame deserialize(DataInputStream in) throws IOException {
            this.myCallerFileName = ZendDebugUtil.readString(in);
            this.myCallerLineNumber = in.readInt();
            this.myCallerFunctionName = ZendDebugUtil.readString(in);
            this.myCalledFileName = ZendDebugUtil.readString(in);
            this.myCalledLineNumber = in.readInt();
            this.myCalledFunctionName = ZendDebugUtil.readString(in);
            int paramsCount = in.readInt();
            for (int i = 0; i < paramsCount; ++i) {
                this.myParameters.add(new Parameter().deserialize(in));
            }
            return this;
        }

        public String getCallerFileName() {
            return this.myCallerFileName;
        }

        public int getCallerLineNumber() {
            return this.myCallerLineNumber;
        }

        public String getCallerFunctionName() {
            return this.myCallerFunctionName;
        }

        public String getCalledFileName() {
            return this.myCalledFileName;
        }

        public int getCalledLineNumber() {
            return this.myCalledLineNumber;
        }

        public String getCalledFunctionName() {
            return this.myCalledFunctionName;
        }

        public List<Pair<String, String>> getParameters() {
            ArrayList<Pair<String, String>> parameters = new ArrayList<Pair<String, String>>();
            for (Parameter parameter : this.myParameters) {
                parameters.add(parameter.getPair());
            }
            return parameters;
        }

        public static class Parameter {
            private String myName;
            private String myValue;

            public Parameter deserialize(DataInputStream in) throws IOException {
                this.myName = ZendDebugUtil.readString(in);
                this.myValue = ZendDebugUtil.readString(in);
                return this;
            }

            public String getName() {
                return this.myName;
            }

            public String getValue() {
                return this.myValue;
            }

            public Pair<String, String> getPair() {
                return Pair.create((Object)this.getName(), (Object)this.getValue());
            }
        }
    }
}

