/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpStaticVsDynamicInspectionBase;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpDynamicAsStaticMethodCallInspection
extends PhpStaticVsDynamicInspectionBase {
    private static final LocalQuickFix MAKE_CALL_DYNAMIC_FIX = new MakeCallDynamicQuickFix();
    public static final String MAKE_CALL_DYNAMIC_FIX_NAME = MAKE_CALL_DYNAMIC_FIX.getName();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDynamicAsStaticMethodCallInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpMethodReference(MethodReference methodReference) {
                Method method;
                PsiElement resolvedElement;
                PsiReference reference;
                if (PhpPsiUtil.isOfType(methodReference.getParent(), PhpStubElementTypes.TRAIT_USE_RULE)) {
                    return;
                }
                String methodName = methodReference.getName();
                if (methodName == null) {
                    return;
                }
                if (methodReference.isStatic() && (reference = methodReference.getReference()) != null && (resolvedElement = reference.resolve()) instanceof Method && !(method = (Method)resolvedElement).isStatic()) {
                    Method containingMethod = (Method)PhpPsiUtil.getParentByCondition((PsiElement)methodReference, true, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (containingMethod == null || !containingMethod.isStatic()) {
                        PhpExpression classReference = methodReference.getClassReference();
                        if (classReference == null) {
                            return;
                        }
                        String classReferenceName = classReference.getName();
                        if ("parent".equals(classReferenceName) || "static".equals(classReferenceName) || "self".equals(classReferenceName)) {
                            return;
                        }
                        PhpClass referringClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)methodReference, PhpClass.class);
                        PhpClass declaringClass = method.getContainingClass();
                        if (referringClass != null && declaringClass != null && (declaringClass.equals(referringClass) || PhpClassHierarchyUtils.isSuperClass((PhpClass)declaringClass, (PhpClass)referringClass, (boolean)false))) {
                            return;
                        }
                    }
                    Project project = methodReference.getProject();
                    PhpType type = methodReference.getClassReference().getType().global(project);
                    boolean hasMagic = PhpCodeInsightUtil.hasMagicMethod(type, PhpIndex.getInstance((Project)project), "__callStatic");
                    if (hasMagic) {
                        if (!PhpDynamicAsStaticMethodCallInspection.this.isShowForMagic()) {
                            return;
                        }
                        holder.registerProblem(methodReference.getNameNode().getPsi(), PhpBundle.message("inspection.dynamic.method.called.as.static.problem.magic", new Object[0]), PhpDynamicAsStaticMethodCallInspection.this.getMagicHighlightType(), new LocalQuickFix[]{MAKE_CALL_DYNAMIC_FIX});
                    } else {
                        holder.registerProblem(methodReference.getNameNode().getPsi(), PhpBundle.message("inspection.dynamic.method.called.as.static.problem", new Object[0]), new LocalQuickFix[]{MAKE_CALL_DYNAMIC_FIX});
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpDynamicAsStaticMethodCallInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDynamicAsStaticMethodCallInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDynamicAsStaticMethodCallInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MakeCallDynamicQuickFix
    extends PhpQuickFixBase {
        @NotNull
        public String getFamilyName() {
            if ("Make call dynamic" == null) {
                MakeCallDynamicQuickFix.$$$reportNull$$$0(0);
            }
            return "Make call dynamic";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement resolve;
            if (project == null) {
                MakeCallDynamicQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MakeCallDynamicQuickFix.$$$reportNull$$$0(2);
            }
            MemberReference methodReference = (MemberReference)PhpPsiUtil.getParentByCondition(descriptor.getPsiElement(), false, (Condition<? super PsiElement>)MemberReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            PhpExpression classReference = methodReference.getClassReference();
            PsiElement arrow = PhpPsiElementFactory.createArrow(project);
            PsiElement scopeResolution = PhpPsiUtil.getChildOfType((PsiElement)methodReference, PhpTokenTypes.SCOPE_RESOLUTION);
            if (scopeResolution == null) {
                MakeCallDynamicQuickFix.showErrorMessage(project, PhpBundle.message("quickfix.can.not.find.static.method.reference", new Object[0]), (PsiElement)methodReference);
                return;
            }
            scopeResolution.replace(arrow);
            if (classReference instanceof ClassReference && (resolve = ((ClassReference)classReference).resolve()) instanceof PhpClass) {
                String name = new PhpType().add(resolve).toStringRelativized(methodReference.getNamespaceName());
                PhpPsiElement expression = PhpPsiElementFactory.createPhpPsiFromText(project, PhpElementTypes.PARENTHESIZED_EXPRESSION, "(new " + name + ")");
                classReference.replace((PsiElement)expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDynamicAsStaticMethodCallInspection$MakeCallDynamicQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDynamicAsStaticMethodCallInspection$MakeCallDynamicQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

