/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing.classes;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ListParsingHelper;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.parser.parsing.calls.Function;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import com.jetbrains.php.lang.parser.parsing.classes.ClassStatementList;
import org.jetbrains.annotations.Nullable;

public class ClassDeclaration {
    private static final ParserPart INTERFACE_PART = new ParserPart(){

        @Override
        public IElementType parse(PhpPsiBuilder builder) {
            return ClassReference.parse(builder);
        }
    };

    public static IElementType parse(PhpPsiBuilder builder) {
        IElementType result = ClassDeclaration.parseInterface(builder);
        if (result == PhpElementTypes.EMPTY_INPUT) {
            result = ClassDeclaration.parseClass(builder, false);
        }
        return result;
    }

    public static IElementType parseClass(PhpPsiBuilder builder, boolean anonymous) {
        if (!(builder.compare(PhpTokenTypes.kwCLASS) || builder.compare(PhpTokenTypes.kwTRAIT) || builder.compare(PhpTokenTypes.kwABSTACT) || builder.compare(PhpTokenTypes.kwFINAL))) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker classMarker = builder.mark();
        if (!builder.compareAndEat(PhpTokenTypes.kwTRAIT)) {
            if (builder.compare(PhpTokenTypes.kwABSTACT) || builder.compare(PhpTokenTypes.kwFINAL)) {
                builder.advanceLexer();
            }
            builder.match(PhpTokenTypes.kwCLASS);
        }
        if (!anonymous && !builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
            builder.error(PhpParserErrors.expected("class name"));
        }
        if (anonymous && builder.compare(PhpTokenTypes.chLPAREN)) {
            Function.parseFunctionCallParameterList(builder);
        }
        if (builder.compare(PhpTokenTypes.IDENTIFIER)) {
            builder.error(PhpParserErrors.expected("extends or implements"));
            builder.advanceLexer();
        }
        ClassDeclaration.parseClassExtends(builder);
        ClassDeclaration.parseClassImplements(builder);
        ClassDeclaration.parseClassStatements(builder);
        classMarker.done(PhpStubElementTypes.CLASS);
        return PhpStubElementTypes.CLASS;
    }

    @Nullable
    private static IElementType parseClassExtends(PhpPsiBuilder builder) {
        PsiBuilder.Marker extendsMarker = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwEXTENDS)) {
            ClassReference.parse(builder);
        }
        extendsMarker.done(PhpElementTypes.EXTENDS_LIST);
        return null;
    }

    private static IElementType parseClassImplements(PhpPsiBuilder builder) {
        PsiBuilder.Marker implementsList = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwIMPLEMENTS)) {
            ClassDeclaration.parseInterfaceList(builder);
        }
        implementsList.done(PhpElementTypes.IMPLEMENTS_LIST);
        return PhpElementTypes.IMPLEMENTS_LIST;
    }

    private static IElementType parseInterface(PhpPsiBuilder builder) {
        if (!builder.compare(PhpTokenTypes.kwINTERFACE)) {
            return PhpElementTypes.EMPTY_INPUT;
        }
        PsiBuilder.Marker interfaceMarker = builder.mark();
        builder.advanceLexer();
        if (!builder.compareAndEat(PhpTokenTypes.IDENTIFIER)) {
            builder.error(PhpParserErrors.expected("interface name"));
        }
        if (builder.compare(PhpTokenTypes.IDENTIFIER)) {
            builder.error(PhpParserErrors.expected("extends"));
            builder.advanceLexer();
        }
        ClassDeclaration.parseInterfaceExtends(builder);
        PsiBuilder.Marker implementsList = builder.mark();
        implementsList.done(PhpElementTypes.IMPLEMENTS_LIST);
        ClassDeclaration.parseClassStatements(builder);
        interfaceMarker.done(PhpStubElementTypes.CLASS);
        return PhpStubElementTypes.CLASS;
    }

    private static void parseClassStatements(PhpPsiBuilder builder) {
        if (!builder.compareAndEat(PhpTokenTypes.chLBRACE)) {
            builder.error(PhpParserErrors.expected(PhpTokenTypes.chLBRACE));
            return;
        }
        ClassStatementList.parse(builder);
        builder.match(PhpTokenTypes.chRBRACE);
    }

    private static IElementType parseInterfaceExtends(PhpPsiBuilder builder) {
        PsiBuilder.Marker extendsList = builder.mark();
        if (builder.compareAndEat(PhpTokenTypes.kwEXTENDS)) {
            ClassDeclaration.parseInterfaceList(builder);
        }
        extendsList.done(PhpElementTypes.EXTENDS_LIST);
        return PhpElementTypes.EXTENDS_LIST;
    }

    private static void parseInterfaceList(PhpPsiBuilder builder) {
        ListParsingHelper.parseCommaDelimitedExpressionWithLeadExpr(builder, INTERFACE_PART.parse(builder), INTERFACE_PART, false);
    }
}

