/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFinder;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.testFramework.PhpTestDescriptor;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTestFinder
implements TestFinder {
    private static final List<PhpTestDescriptor> DESCRIPTORS = ContainerUtil.map((Object[])PhpTestFrameworkType.getTestFrameworkTypes(), PhpTestFrameworkType::getDescriptor);

    public PhpNamedElement findSourceElement(@NotNull PsiElement from) {
        if (from == null) {
            PhpTestFinder.$$$reportNull$$$0(0);
        }
        return (PhpNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)from, (Class[])new Class[]{PhpClass.class, Method.class});
    }

    @NotNull
    public Collection<PsiElement> findTestsForClass(@NotNull PsiElement element) {
        PhpNamedElement sourceElement;
        if (element == null) {
            PhpTestFinder.$$$reportNull$$$0(1);
        }
        if ((sourceElement = this.findSourceElement(element)) instanceof Method) {
            PhpClass containingClass = ((Method)sourceElement).getContainingClass();
            Collection<PsiElement> testsForMethod = PhpTestFinder.flatFromDescriptors(descriptor -> descriptor.findTests((Method)sourceElement), containingClass);
            Collection<PsiElement> collection = !testsForMethod.isEmpty() || containingClass == null ? testsForMethod : this.findTestsForClass((PsiElement)containingClass);
            if (collection == null) {
                PhpTestFinder.$$$reportNull$$$0(2);
            }
            return collection;
        }
        if (sourceElement instanceof PhpClass) {
            Collection<PsiElement> collection = PhpTestFinder.flatFromDescriptors(descriptor -> descriptor.findTests((PhpClass)sourceElement), (PhpClass)sourceElement);
            if (collection == null) {
                PhpTestFinder.$$$reportNull$$$0(3);
            }
            return collection;
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            PhpTestFinder.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Collection<PsiElement> findClassesForTest(@NotNull PsiElement element) {
        PhpNamedElement sourceElement;
        if (element == null) {
            PhpTestFinder.$$$reportNull$$$0(5);
        }
        if ((sourceElement = this.findSourceElement(element)) instanceof Method) {
            PhpClass containingClass = ((Method)sourceElement).getContainingClass();
            Collection<PsiElement> targetsForMethod = PhpTestFinder.flatFromDescriptors(descriptor -> descriptor.findMethods((Method)sourceElement), containingClass);
            Collection<PsiElement> collection = !targetsForMethod.isEmpty() || containingClass == null ? targetsForMethod : this.findClassesForTest((PsiElement)containingClass);
            if (collection == null) {
                PhpTestFinder.$$$reportNull$$$0(6);
            }
            return collection;
        }
        if (sourceElement instanceof PhpClass) {
            String name = sourceElement.getName();
            Collection<PsiElement> collection = PhpTestFinder.flatFromDescriptors(descriptor -> descriptor.findClasses((PhpClass)sourceElement, name), (PhpClass)sourceElement);
            if (collection == null) {
                PhpTestFinder.$$$reportNull$$$0(7);
            }
            return collection;
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            PhpTestFinder.$$$reportNull$$$0(8);
        }
        return set;
    }

    public boolean isTest(@NotNull PsiElement element) {
        PhpNamedElement sourceElement;
        if (element == null) {
            PhpTestFinder.$$$reportNull$$$0(9);
        }
        if ((sourceElement = this.findSourceElement(element)) instanceof PhpClass) {
            PhpClass testClass = (PhpClass)sourceElement;
            if (testClass.isInterface() || testClass.isAbstract() || testClass.isTrait()) {
                return false;
            }
            for (PhpTestDescriptor descriptor : DESCRIPTORS) {
                if (!descriptor.isTestClassName(testClass.getName())) continue;
                return true;
            }
        }
        if (sourceElement instanceof Method) {
            if (sourceElement instanceof PhpDocMethod) {
                return false;
            }
            PhpClass containingClass = ((Method)sourceElement).getContainingClass();
            return containingClass != null && this.isTest((PsiElement)containingClass);
        }
        return false;
    }

    @NotNull
    private static <T extends PhpNamedElement> Collection<PsiElement> flatFromDescriptors(@NotNull Function<PhpTestDescriptor, Collection<T>> f, @Nullable PhpClass clazz) {
        if (f == null) {
            PhpTestFinder.$$$reportNull$$$0(10);
        }
        String namespace = clazz != null ? clazz.getNamespaceName() : null;
        List elementsWithWeights = StreamEx.of(DESCRIPTORS).toFlatList(f).stream().map(e -> Pair.create((Object)e, (Object)PhpTestFinder.getWeight(e, namespace))).collect(Collectors.toList());
        List list = TestFinderHelper.getSortedElements(elementsWithWeights, (boolean)false);
        if (list == null) {
            PhpTestFinder.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static int getWeight(PhpNamedElement e, @Nullable String targetClassNamespaceName) {
        PhpClass clazz;
        PhpClass phpClass = clazz = e instanceof PhpClass ? (PhpClass)e : ((Method)e).getContainingClass();
        if (clazz == null) {
            return 0;
        }
        if (ProjectFileIndex.getInstance((Project)e.getProject()).isInLibrarySource(e.getContainingFile().getVirtualFile())) {
            return 1;
        }
        if (!PhpLangUtil.equalsNamespaceNames(clazz.getNamespaceName(), targetClassNamespaceName)) {
            return 2;
        }
        return 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpTestFinder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpTestFinder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestsForClass";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesForTest";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "flatFromDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSourceElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTestsForClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findClassesForTest";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "flatFromDescriptors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

