/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.automaticRenamers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ParametersRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            ParametersRenamerFactory.$$$reportNull$$$0(0);
        }
        if (!(element instanceof Parameter)) {
            return false;
        }
        Function function = (Function)PsiTreeUtil.getParentOfType((PsiElement)element, Function.class);
        return function instanceof Method;
    }

    public String getOptionName() {
        return RefactoringBundle.message((String)"rename.parameters.hierarchy");
    }

    public boolean isEnabled() {
        return PhpRefactoringSettings.getInstance().RENAME_PARAMETERS;
    }

    public void setEnabled(boolean enabled) {
        PhpRefactoringSettings.getInstance().RENAME_PARAMETERS = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        ParametersRenamer parametersRenamer = new ParametersRenamer((Parameter)element, newName);
        if (parametersRenamer == null) {
            ParametersRenamerFactory.$$$reportNull$$$0(1);
        }
        return parametersRenamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/automaticRenamers/ParametersRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/automaticRenamers/ParametersRenamerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ParametersRenamer
    extends AutomaticRenamer {
        public ParametersRenamer(@NotNull Parameter parameter, @NotNull String newName) {
            if (parameter == null) {
                ParametersRenamer.$$$reportNull$$$0(0);
            }
            if (newName == null) {
                ParametersRenamer.$$$reportNull$$$0(1);
            }
            String parameterName = parameter.getName();
            Project project = parameter.getProject();
            Method method = (Method)PsiTreeUtil.getParentOfType((PsiElement)parameter, Method.class);
            assert (method != null);
            int parameterIndex = Arrays.asList(method.getParameters()).indexOf(parameter);
            if (parameterIndex == -1) {
                return;
            }
            ArrayList params = new ArrayList();
            ArrayList list = new ArrayList();
            PhpClassHierarchyUtils.HierarchyClassMemberProcessor collectParameters = (member, subClass, baseClass) -> {
                Method method1 = (Method)member;
                list.add(method1);
                Parameter[] parameters = method1.getParameters();
                if (parameters.length > parameterIndex) {
                    params.add(parameters[parameterIndex]);
                }
                return true;
            };
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)collectParameters);
            for (Method curMethod : new ArrayList(list)) {
                PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)curMethod, (PhpIndex)PhpIndex.getInstance((Project)project), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)collectParameters);
            }
            PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)method, (PhpIndex)PhpIndex.getInstance((Project)project), (PhpClassHierarchyUtils.HierarchyClassMemberProcessor)collectParameters);
            this.myElements.addAll(params);
            this.suggestAllNames(parameterName, newName);
        }

        public String getDialogTitle() {
            return "Rename Parameters";
        }

        public String getDialogDescription() {
            return "Rename parameter in hierarchy to:";
        }

        public String entityName() {
            return "Parameter";
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/refactoring/rename/automaticRenamers/ParametersRenamerFactory$ParametersRenamer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

