/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessHandler;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolProcessCreator {
    private static final Logger LOG = Logger.getInstance(QualityToolProcessCreator.class);
    private static final ExecutorService myToolExecutorService = Executors.newFixedThreadPool(5, ConcurrencyUtil.newNamedThreadFactory((String)"PHP tool executor"));

    @NotNull
    public static ProcessOutput getToolOutput(@NotNull Project project, @Nullable String interpreterId, @NotNull String path, int timeout, @NotNull String title, @Nullable JComponent component, String ... params) throws com.intellij.execution.ExecutionException {
        String validate;
        if (project == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(0);
        }
        if (path == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(1);
        }
        if (title == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(2);
        }
        if (params == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(3);
        }
        PhpSdkAdditionalData data = StringUtil.isNotEmpty((String)interpreterId) ? PhpInterpretersManagerImpl.getInstance(project).findInterpreterDataById(interpreterId) : null;
        String string = validate = data != null ? data.validate(project, null) : null;
        if (StringUtil.isNotEmpty((String)validate)) {
            throw new com.intellij.execution.ExecutionException(validate);
        }
        PhpCommandSettings command = PhpCommandSettingsBuilder.create(path, PhpCommandLinePathProcessor.IDENTICAL, data);
        Arrays.stream(params).forEach(command::addArgument);
        QualityToolProcessCreator.logProcessStart(path, params);
        ProcessOutput processOutput = PhpExecutionUtil.getProcessOutput(project, data, command.createGeneralCommandLine(), title, component, timeout);
        if (processOutput == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(4);
        }
        return processOutput;
    }

    public static void runToolProcess(@Nullable Project project, @Nullable String interpreterId, @NotNull String path, int timeout, @Nullable QualityToolBlackList blackList, @NotNull QualityToolMessageProcessor messageProcessor, @Nullable String workingDirectory, @Nullable VirtualFile originalFile, @Nullable PhpSdkFileTransfer transfer, String ... params) throws com.intellij.execution.ExecutionException {
        if (path == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(5);
        }
        if (messageProcessor == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(6);
        }
        if (blackList != null && originalFile != null && blackList.containsFile(originalFile)) {
            return;
        }
        try {
            ProcessHandler handler = myToolExecutorService.submit(() -> {
                if (path == null) {
                    QualityToolProcessCreator.$$$reportNull$$$0(13);
                }
                if (messageProcessor == null) {
                    QualityToolProcessCreator.$$$reportNull$$$0(14);
                }
                ProcessHandler handler1 = QualityToolProcessCreator.createProcessHandler(project, path, interpreterId, messageProcessor, workingDirectory, transfer, params);
                handler1.startNotify();
                handler1.waitFor((long)(2 * timeout / 3));
                return handler1;
            }).get(timeout, TimeUnit.MILLISECONDS);
            if (!handler.isProcessTerminated()) {
                handler.destroyProcess();
                messageProcessor.addInternalMessage(1, QualityToolProcessCreator.getHangupMessage(path, timeout, params));
            }
        }
        catch (TimeoutException e) {
            throw new com.intellij.execution.ExecutionException(StringUtil.isEmpty((String)e.getMessage()) ? "No response from " + path + " after " + timeout + " ms" : e.getMessage());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
    }

    public static void runToolProcess(@NotNull QualityToolAnnotatorInfo info, @Nullable QualityToolBlackList blackList, @NotNull QualityToolMessageProcessor messageProcessor, @Nullable String workingDirectory, @Nullable PhpSdkFileTransfer transfer, List<String> params) throws com.intellij.execution.ExecutionException {
        if (info == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(7);
        }
        if (messageProcessor == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(8);
        }
        QualityToolProcessCreator.runToolProcess(info.getProject(), info.getInterpreterId(), info.getToolPath(), info.getTimeout(), blackList, messageProcessor, workingDirectory, info.getOriginalFile(), transfer, ArrayUtilRt.toStringArray(params));
    }

    public static ProcessHandler createProcessHandler(@Nullable Project project, @NotNull String path, @Nullable String interpreterId, @NotNull QualityToolMessageProcessor messageProcessor, @Nullable String workingDirectory, @Nullable PhpSdkFileTransfer transfer, String ... params) throws com.intellij.execution.ExecutionException {
        if (path == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(9);
        }
        if (messageProcessor == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(10);
        }
        if (project != null && StringUtil.isNotEmpty((String)interpreterId)) {
            PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
            if (interpreter == null) {
                throw new com.intellij.execution.ExecutionException("Can not find specified interpreter");
            }
            if (interpreter.isRemote()) {
                PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                if (manager == null) {
                    throw new com.intellij.execution.ExecutionException("Remote interpreter can't be executed. Please enable the PHP Remote Interpreter plugin.");
                }
                PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
                String validate = data.validate(project, null);
                if (StringUtil.isNotEmpty((String)validate)) {
                    throw new com.intellij.execution.ExecutionException(validate);
                }
                PhpCommandSettings command = PhpCommandSettingsBuilder.create(path, PhpCommandLinePathProcessor.IDENTICAL, data);
                Arrays.stream(params).forEach(command::addArgument);
                if (transfer != null) {
                    transfer.updateCommand(command);
                }
                QualityToolProcessCreator.logProcessStart(path, params);
                GeneralCommandLine commandLine = command.createGeneralCommandLine();
                if (StringUtil.isNotEmpty((String)workingDirectory)) {
                    commandLine.setWorkDirectory(workingDirectory);
                }
                return manager.getRemoteToolProcessHandler(project, messageProcessor, data, commandLine, command.getAdditionalMappings());
            }
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        if (StringUtil.isNotEmpty((String)workingDirectory)) {
            cl.setWorkDirectory(workingDirectory);
        }
        cl.setExePath(path);
        cl.addParameters(params);
        QualityToolProcessCreator.logProcessStart(path, params);
        return new QualityToolProcessHandler(cl, messageProcessor);
    }

    private static void logProcessStart(String path, String ... params) {
        StringBuilder buf = new StringBuilder();
        buf.append("Running external tool: ");
        buf.append(path);
        Arrays.stream(params).forEach(param -> buf.append(' ').append((String)param));
        LOG.debug(buf.toString());
    }

    @NotNull
    private static String getHangupMessage(@NotNull String path, int timeout, String[] params) {
        if (path == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(11);
        }
        LOG.info("No response from " + path + " after " + timeout + " ms");
        StringBuilder infoMessage = new StringBuilder();
        infoMessage.append("Can not correctly run the tool with parameters:\n");
        Arrays.stream(params).forEach(param -> infoMessage.append("  ").append((String)param).append('\n'));
        infoMessage.append("Possible tool process hangup after ").append(timeout / 1000);
        infoMessage.append(" sec.");
        String string = infoMessage.toString();
        if (string == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolProcessCreator";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolProcessCreator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolOutput";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getHangupMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getToolOutput";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runToolProcess";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHangupMessage";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runToolProcess$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

