/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty.lang.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.smarty.config.SmartyConfiguration;
import com.jetbrains.smarty.lang.SmartyTokenTypes;
import com.jetbrains.smarty.lang.lexer.SmartySemanticLexer;
import com.jetbrains.smarty.lang.lexer._SmartyLexer;
import org.jetbrains.annotations.Nullable;

public class SmartyLexer
extends MergingLexerAdapter {
    private static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{SmartyTokenTypes.COMMENT, SmartyTokenTypes.WHITE_SPACE});
    public static final String DEFAULT_LEFT_DELIMITER = "{";
    public static final String DEFAULT_RIGHT_DELIMITER = "}";
    public static final Pair<String, String> DEFAULT_DELIMITERS = Pair.create((Object)"{", (Object)"}");

    public static String getRightDelimiter(@Nullable Project project) {
        return project == null ? DEFAULT_RIGHT_DELIMITER : (String)SmartyConfiguration.getInstance((Project)project).getSmartyDelimiters().second;
    }

    public static String getLeftDelimiter(@Nullable Project project) {
        return project == null ? DEFAULT_LEFT_DELIMITER : (String)SmartyConfiguration.getInstance((Project)project).getSmartyDelimiters().first;
    }

    public SmartyLexer(FlexLexer lexerToUse) {
        super((Lexer)new FlexAdapter(lexerToUse), TOKENS_TO_MERGE);
    }

    public static Lexer createLexerForTests(Pair<String, String> delimiters, boolean isWhitespacesAllowed) {
        return new SmartySemanticLexer((String)delimiters.first, (String)delimiters.second, isWhitespacesAllowed);
    }

    public static Lexer createLexer(@Nullable Project project) {
        return new SmartySemanticLexer(SmartyLexer.getLeftDelimiter(project), SmartyLexer.getRightDelimiter(project), project == null || !SmartyConfiguration.getInstance(project).getState().isSmarty3Whitespaces());
    }

    public static FlexAdapter createAdapter() {
        return new FlexAdapter((FlexLexer)new _SmartyLexer());
    }
}

