/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.PrivateKeyReader;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.security.CompositeX509TrustManager;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SslSocketFactory
extends SSLSocketFactory {
    public static final String SSL_CA_CERT_PATH = "sslCaCertPath";
    public static final String SSL_CLIENT_CERT_PATH = "sslClientCertPath";
    public static final String SSL_CLIENT_KEY_PATH = "sslClientKeyPath";
    public static final String SSL_TRUST_EVERYBODY = "sslTrustEverybody";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private final SSLSocketFactory myFactory;

    public SslSocketFactory() throws GeneralSecurityException, IOException {
        KeyManager[] kms;
        TrustManager[] tms;
        SSLContext ctx = SSLContext.getInstance("TLS");
        try {
            KeyManager[] keyManagerArray;
            TrustManager[] trustManagerArray;
            String caCertPath = System.getProperty(SSL_CA_CERT_PATH);
            String clientCertPath = System.getProperty(SSL_CLIENT_CERT_PATH);
            String clientKeyPath = System.getProperty(SSL_CLIENT_KEY_PATH);
            boolean trustEverybody = Boolean.parseBoolean(System.getProperty(SSL_TRUST_EVERYBODY));
            if (trustEverybody) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = new MyTrustEverybodyManager();
            } else {
                trustManagerArray = tms = caCertPath == null ? new TrustManager[]{} : SslSocketFactory.createTrustManagers(caCertPath);
            }
            if (clientCertPath != null && clientKeyPath != null) {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = new MyKeyManager(clientCertPath, clientKeyPath);
            } else {
                keyManagerArray = new KeyManager[]{};
            }
            kms = keyManagerArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctx.init(kms, tms, null);
        this.myFactory = ctx.getSocketFactory();
    }

    @NotNull
    public static TrustManager[] createTrustManagers(@NotNull String caCertPath) throws Exception {
        if (caCertPath == null) {
            SslSocketFactory.$$$reportNull$$$0(0);
        }
        String string = FileUtilRt.loadFile(new File(caCertPath));
        String[] tokens = string.split(END_CERTIFICATE);
        ArrayList<TrustManager> result = ContainerUtilRt.newArrayListWithCapacity(tokens.length);
        for (String token : tokens) {
            if (token == null || token.trim().length() == 0) continue;
            result.add(new MyTrustManager(SslSocketFactory.readCertificate(SslSocketFactory.stringStream(token + END_CERTIFICATE))));
        }
        TrustManager[] trustManagerArray = new TrustManager[]{new CompositeX509TrustManager(new TrustManager[][]{result.toArray(new TrustManager[0])})};
        if (trustManagerArray == null) {
            SslSocketFactory.$$$reportNull$$$0(1);
        }
        return trustManagerArray;
    }

    @NotNull
    public static InputStream stringStream(@NotNull String str) {
        ByteArrayInputStream byteArrayInputStream;
        block3: {
            if (str == null) {
                SslSocketFactory.$$$reportNull$$$0(2);
            }
            try {
                byteArrayInputStream = new ByteArrayInputStream(str.getBytes("UTF-8"));
                if (byteArrayInputStream != null) break block3;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            SslSocketFactory.$$$reportNull$$$0(3);
        }
        return byteArrayInputStream;
    }

    @NotNull
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.myFactory.createSocket(host, port);
        if (socket == null) {
            SslSocketFactory.$$$reportNull$$$0(4);
        }
        return socket;
    }

    @NotNull
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.myFactory.createSocket(host, port);
        if (socket == null) {
            SslSocketFactory.$$$reportNull$$$0(5);
        }
        return socket;
    }

    @NotNull
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = this.myFactory.createSocket(host, port, localHost, localPort);
        if (socket == null) {
            SslSocketFactory.$$$reportNull$$$0(6);
        }
        return socket;
    }

    @NotNull
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.myFactory.createSocket(address, port, localAddress, localPort);
        if (socket == null) {
            SslSocketFactory.$$$reportNull$$$0(7);
        }
        return socket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.myFactory.createSocket(socket, host, port, autoClose);
    }

    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.myFactory.getDefaultCipherSuites();
        if (stringArray == null) {
            SslSocketFactory.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.myFactory.getSupportedCipherSuites();
        if (stringArray == null) {
            SslSocketFactory.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull String filePath) throws CertificateException, IOException {
        if (filePath == null) {
            SslSocketFactory.$$$reportNull$$$0(10);
        }
        X509Certificate x509Certificate = SslSocketFactory.readCertificate(new FileInputStream(filePath));
        if (x509Certificate == null) {
            SslSocketFactory.$$$reportNull$$$0(11);
        }
        return x509Certificate;
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull InputStream stream) throws CertificateException, IOException {
        if (stream == null) {
            SslSocketFactory.$$$reportNull$$$0(12);
        }
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(stream);
        stream.close();
        X509Certificate x509Certificate = certificate;
        if (x509Certificate == null) {
            SslSocketFactory.$$$reportNull$$$0(13);
        }
        return x509Certificate;
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            SslSocketFactory.$$$reportNull$$$0(14);
        }
        PrivateKey privateKey = new PrivateKeyReader(filePath).getPrivateKey();
        if (privateKey == null) {
            SslSocketFactory.$$$reportNull$$$0(15);
        }
        return privateKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caCertPath";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/ssl/SslSocketFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/ssl/SslSocketFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrustManagers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "stringStream";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSocket";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCipherSuites";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedCipherSuites";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readCertificate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readPrivateKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTrustManagers";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "stringStream";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readCertificate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readPrivateKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyKeyManager
    extends X509ExtendedKeyManager {
        private final String myAlias;
        @NotNull
        private final X509Certificate[] myCertificates;
        @NotNull
        private final PrivateKey myPrivateKey;

        private MyKeyManager(@NotNull String certPath, @NotNull String keyPath) throws Exception {
            if (certPath == null) {
                MyKeyManager.$$$reportNull$$$0(0);
            }
            if (keyPath == null) {
                MyKeyManager.$$$reportNull$$$0(1);
            }
            this.myAlias = UUID.randomUUID().toString();
            this.myCertificates = new X509Certificate[]{SslSocketFactory.readCertificate(certPath)};
            this.myPrivateKey = SslSocketFactory.readPrivateKey(keyPath);
        }

        @NotNull
        public String[] getClientAliases(String s, Principal[] principals) {
            String[] stringArray = new String[]{};
            if (stringArray == null) {
                MyKeyManager.$$$reportNull$$$0(2);
            }
            return stringArray;
        }

        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.myAlias;
        }

        @NotNull
        public String[] getServerAliases(String s, Principal[] principals) {
            String[] stringArray = new String[]{};
            if (stringArray == null) {
                MyKeyManager.$$$reportNull$$$0(3);
            }
            return stringArray;
        }

        @Nullable
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return null;
        }

        @NotNull
        public X509Certificate[] getCertificateChain(String s) {
            if (this.myCertificates == null) {
                MyKeyManager.$$$reportNull$$$0(4);
            }
            return this.myCertificates;
        }

        @NotNull
        public PrivateKey getPrivateKey(String s) {
            PrivateKey privateKey = this.myPrivateKey;
            if (privateKey == null) {
                MyKeyManager.$$$reportNull$$$0(5);
            }
            return privateKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "certPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyPath";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClientAliases";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getServerAliases";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCertificateChain";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrivateKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyTrustEverybodyManager
    implements X509TrustManager {
        private MyTrustEverybodyManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{};
            if (x509CertificateArray == null) {
                MyTrustEverybodyManager.$$$reportNull$$$0(0);
            }
            return x509CertificateArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustEverybodyManager", "getAcceptedIssuers"));
        }
    }

    private static class MyTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;

        private MyTrustManager(@NotNull X509Certificate caCertPath) throws Exception {
            if (caCertPath == null) {
                MyTrustManager.$$$reportNull$$$0(0);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(MyTrustManager.createStore(caCertPath));
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.trustManager = (X509TrustManager)tm;
                break;
            }
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
        }

        @NotNull
        private static KeyStore createStore(@NotNull X509Certificate certificate) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
            if (certificate == null) {
                MyTrustManager.$$$reportNull$$$0(1);
            }
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry(UUID.randomUUID().toString(), certificate);
            KeyStore keyStore = ks;
            if (keyStore == null) {
                MyTrustManager.$$$reportNull$$$0(2);
            }
            return keyStore;
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }

        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{};
            if (x509CertificateArray == null) {
                MyTrustManager.$$$reportNull$$$0(3);
            }
            return x509CertificateArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caCertPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "certificate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStore";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAcceptedIssuers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createStore";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

