/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBRdbmsProvider;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateRdbmsProvider;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateRdbmsProvider;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateRdbmsProvider;

public class BaseRdbmsProvider
implements DBRdbmsProvider {
    @NotNull
    private final IntegralIntermediateRdbmsProvider myIntermediateProvider;

    public BaseRdbmsProvider(@NotNull PrimeIntermediateRdbmsProvider primeIntermediateProvider) {
        this(BaseRdbmsProvider.adaptIntermediateProvider(primeIntermediateProvider));
    }

    @NotNull
    private static IntegralIntermediateRdbmsProvider adaptIntermediateProvider(@NotNull PrimeIntermediateRdbmsProvider primeIntermediateProvider) {
        return new AdaptIntermediateRdbmsProvider(primeIntermediateProvider);
    }

    public BaseRdbmsProvider(@NotNull IntegralIntermediateRdbmsProvider integralIntermediateProvider) {
        this.myIntermediateProvider = integralIntermediateProvider;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return this.myIntermediateProvider.rdbms();
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return this.myIntermediateProvider.connectionStringPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public BaseFacade openFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, boolean connect) {
        boolean ok = false;
        IntegralIntermediateFacade intermediateFacade = this.myIntermediateProvider.openFacade(connectionString, connectionProperties, connectionsLimit);
        try {
            BaseFacade facade = new BaseFacade(intermediateFacade);
            if (connect) {
                facade.connect();
            }
            ok = true;
            BaseFacade baseFacade = facade;
            return baseFacade;
        }
        finally {
            if (!ok) {
                intermediateFacade.disconnect();
            }
        }
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        return this.myIntermediateProvider.getSpecificService(serviceClass, serviceName);
    }
}

