/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.util.Classes;
import org.jetbrains.dekaf.util.NameAndClass;

public abstract class Layouts {
    private static final ResultLayout<Boolean> EXISTENCE = new ResultLayout(ResultLayout.Kind.EXISTENCE, false, new RowLayout<Void>(RowLayout.Kind.EXISTENCE, Void.class, Void.class, new Class[0]));

    @NotNull
    public static <V> RowLayout<V> oneOf(@NotNull Class<V> valueClass) {
        return new RowLayout<V>(RowLayout.Kind.ONE_VALUE, valueClass, valueClass, valueClass);
    }

    @NotNull
    public static <V> RowLayout<V[]> arrayOf(int n, @NotNull Class<V> componentClass) {
        Object[] example = (Object[])Array.newInstance(componentClass, 0);
        Class<?> resultClass = example.getClass();
        Class[] componentClasses = new Class[n];
        for (int i = 0; i < n; ++i) {
            componentClasses[i] = componentClass;
        }
        return new RowLayout<V[]>(RowLayout.Kind.ARRAY, resultClass, componentClass, componentClasses);
    }

    @NotNull
    public static RowLayout<Object[]> arrayOf(Class ... componentClasses) {
        return new RowLayout<Object[]>(RowLayout.Kind.ARRAY, Object[].class, Object.class, componentClasses);
    }

    @NotNull
    public static RowLayout<Object[]> rawArray() {
        return new RowLayout<Object[]>(RowLayout.Kind.ARRAY, Object[].class, Object.class, new Class[0]);
    }

    @NotNull
    public static RowLayout<int[]> arrayOfInts() {
        return new RowLayout<int[]>(RowLayout.Kind.ARRAY, int[].class, Integer.TYPE, new Class[0]);
    }

    @NotNull
    public static RowLayout<long[]> arrayOfLongs() {
        return new RowLayout<long[]>(RowLayout.Kind.ARRAY, long[].class, Long.TYPE, new Class[0]);
    }

    @NotNull
    public static <C> RowLayout<C> structOf(@NotNull Class<C> structClass) {
        NameAndClass[] assignableFields = Classes.assignableFieldsOf(structClass);
        return new RowLayout<C>(RowLayout.Kind.STRUCT, structClass, Object.class, assignableFields);
    }

    public static ResultLayout<Boolean> existence() {
        return EXISTENCE;
    }

    public static <V> ResultLayout<V> singleOf(@NotNull Class<V> valueClass) {
        return new ResultLayout(ResultLayout.Kind.SINGLE_ROW, false, Layouts.oneOf(valueClass));
    }

    public static <R> ResultLayout<R> rowOf(@NotNull RowLayout<R> rowLayout) {
        return new ResultLayout(ResultLayout.Kind.SINGLE_ROW, false, rowLayout);
    }

    public static <V> ResultLayout<V[]> columnOf(@NotNull Class<V> valueClass) {
        return new ResultLayout<V[]>(ResultLayout.Kind.ARRAY, false, Layouts.oneOf(valueClass));
    }

    public static ResultLayout<int[]> columnOfInts(int initialCapacity) {
        return new ResultLayout<int[]>(ResultLayout.Kind.ARRAY_OF_PRIMITIVES, false, Layouts.oneOf(Integer.TYPE), initialCapacity);
    }

    public static ResultLayout<long[]> columnOfLongs(int initialCapacity) {
        return new ResultLayout<long[]>(ResultLayout.Kind.ARRAY_OF_PRIMITIVES, false, Layouts.oneOf(Long.TYPE), initialCapacity);
    }

    public static <R> ResultLayout<R[]> arrayOf(@NotNull RowLayout<R> rowLayout) {
        return new ResultLayout<R[]>(ResultLayout.Kind.ARRAY, false, rowLayout);
    }

    public static <R> ResultLayout<List<R>> listOf(@NotNull RowLayout<R> rowLayout) {
        return new ResultLayout<List<R>>(ResultLayout.Kind.LIST, false, rowLayout);
    }

    public static <K, V> ResultLayout<Map<K, V>> hashMapOf(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        return new ResultLayout<Map<K, V>>(ResultLayout.Kind.MAP, false, Layouts.arrayOf(keyClass, valueClass));
    }

    public static <K extends Comparable<K>, V> ResultLayout<SortedMap<K, V>> sortedMapOf(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        return new ResultLayout<SortedMap<K, V>>(ResultLayout.Kind.MAP, true, Layouts.arrayOf(keyClass, valueClass));
    }
}

