/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Collects {
    @NotNull
    public static <T> List<T> listCopy(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        int n = collection.size();
        if (n == 1) {
            return Collections.singletonList(collection.iterator().next());
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    @NotNull
    public static String arrayToString(Object[] array, String delimiter) {
        if (array == null) {
            return "";
        }
        int n = array.length;
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return array[0].toString();
            }
        }
        StringBuilder b = new StringBuilder();
        b.append(array[0].toString());
        for (int i = 1; i < n; ++i) {
            b.append(delimiter).append(array[i]);
        }
        return b.toString();
    }

    @NotNull
    public static <T> T[][] splitArrayPer(@NotNull T[] array, int limitPerPack) {
        int n = array.length;
        Class<?> arrayType = array.getClass();
        int m = n / limitPerPack;
        int r = n % limitPerPack;
        if (r > 0) {
            ++m;
        }
        Object[][] packs = (Object[][])Array.newInstance(arrayType, m);
        int k = 0;
        for (int i = 0; i < m && k < n; ++i, k += limitPerPack) {
            int end = Math.min(k + limitPerPack, n);
            packs[i] = Arrays.copyOfRange(array, k, end);
        }
        return packs;
    }

    @NotNull
    public static String collectionToString(@Nullable Iterable collection, @Nullable String delimiter) {
        return Collects.collectionToString(collection, delimiter, null, null, null);
    }

    @NotNull
    public static String collectionToString(@Nullable Iterable collection, @Nullable String delimiter, @Nullable String prefix, @Nullable String suffix, @Nullable String empty) {
        if (collection == null) {
            return empty == null ? "" : empty;
        }
        StringBuilder b = new StringBuilder();
        for (Object object : collection) {
            if (b.length() == 0) {
                if (prefix != null) {
                    b.append(prefix);
                }
            } else if (delimiter != null) {
                b.append(delimiter);
            }
            b.append(object);
        }
        if (b.length() > 0) {
            if (suffix != null) {
                b.append(suffix);
            }
        } else if (empty != null) {
            b.append(empty);
        }
        return b.toString();
    }
}

