/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.navigation;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.util.NavigationItemListCellRenderer;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.navigation.YAMLKeyNavigationItem;
import org.jetbrains.yaml.navigation.YAMLKeysIndex;

public class YAMLKeysSearchEverywhereContributor
implements SearchEverywhereContributor<Language> {
    @Nullable
    final Project myProject;

    public YAMLKeysSearchEverywhereContributor(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupName() {
        String string = YAMLBundle.message("YAMLKeysSearchEverywhereContributor.group.name");
        if (string == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String includeNonProjectItemsText() {
        return null;
    }

    public int getSortWeight() {
        return 1000;
    }

    public boolean showInFindResults() {
        return true;
    }

    public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<Language> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
        if (pattern == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(4);
        }
        if (this.myProject == null || DumbService.getInstance((Project)this.myProject).isDumb() || pattern.isEmpty()) {
            return;
        }
        Runnable task = () -> {
            if (consumer == null) {
                YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(17);
            }
            if (pattern == null) {
                YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(18);
            }
            if (progressIndicator == null) {
                YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(19);
            }
            this.findKeys(consumer, pattern, everywhere, progressIndicator);
        };
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            application.runReadAction(task);
        } else {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)task, (ProgressIndicator)progressIndicator);
        }
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        if (selected == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(5);
        }
        if (searchText == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(6);
        }
        if (selected instanceof Navigatable) {
            ((Navigatable)selected).navigate(true);
        }
        return true;
    }

    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> list) {
        if (list == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(7);
        }
        NavigationItemListCellRenderer navigationItemListCellRenderer = new NavigationItemListCellRenderer();
        if (navigationItemListCellRenderer == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(8);
        }
        return navigationItemListCellRenderer;
    }

    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        if (element == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(9);
        }
        if (dataId == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(10);
        }
        return null;
    }

    private void findKeys(@NotNull Function<Object, Boolean> consumer, @NotNull String pattern, boolean everywhere, ProgressIndicator progressIndicator) {
        if (consumer == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(11);
        }
        if (pattern == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(12);
        }
        if (this.myProject == null) {
            return;
        }
        Collection allKeys = FileBasedIndex.getInstance().getAllKeys(YAMLKeysIndex.KEY, this.myProject);
        List<String> sorted = YAMLKeysSearchEverywhereContributor.applyPattern(allKeys, pattern, progressIndicator);
        for (String name : sorted) {
            progressIndicator.checkCanceled();
            CommonProcessors.CollectProcessor files = new CommonProcessors.CollectProcessor();
            GlobalSearchScope filter = everywhere ? ProjectScope.getAllScope((Project)this.myProject) : ProjectScope.getProjectScope((Project)this.myProject);
            FileBasedIndex.getInstance().getFilesWithKey(YAMLKeysIndex.KEY, Collections.singleton(name), (Processor)files, filter);
            for (VirtualFile file : files.getResults()) {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                if (psiFile == null) continue;
                ArrayList positions = FileBasedIndex.getInstance().getValues(YAMLKeysIndex.KEY, (Object)name, GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)file));
                if (positions.size() > 1) {
                    positions = new ArrayList(positions);
                    Collections.sort(positions);
                }
                Iterator iterator = positions.iterator();
                while (iterator.hasNext()) {
                    int pos = (Integer)iterator.next();
                    Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.myProject, file, pos);
                    if (consumer.apply(new YAMLKeyNavigationItem(navigatable, name, file)).booleanValue()) continue;
                    return;
                }
            }
        }
    }

    @Contract(pure=true)
    @NotNull
    private static List<String> applyPattern(@NotNull Collection<String> keys, @NotNull String pattern, ProgressIndicator progressIndicator) {
        if (keys == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(13);
        }
        if (pattern == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(14);
        }
        MultiMap priority = MultiMap.create();
        for (String key : keys) {
            progressIndicator.checkCanceled();
            int start = key.indexOf(pattern);
            if (start == -1 || start > 0 && key.charAt(start - 1) != '.' || start + pattern.length() < key.length() && key.indexOf(".", start + pattern.length()) != -1) continue;
            int dots = YAMLKeysSearchEverywhereContributor.countDots(key, start);
            priority.putValue((Object)dots, (Object)key);
        }
        progressIndicator.checkCanceled();
        List<String> list = priority.keySet().stream().sorted().map(idx -> priority.get(idx)).map(found -> found.stream().sorted()).flatMap(s -> s).collect(Collectors.toList());
        if (list == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Contract(pure=true)
    private static int countDots(@NotNull String path, int end) {
        if (path == null) {
            YAMLKeysSearchEverywhereContributor.$$$reportNull$$$0(16);
        }
        int count = 0;
        for (int i = 0; i < end; ++i) {
            if (path.charAt(i) != '.') continue;
            ++count;
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/navigation/YAMLKeysSearchEverywhereContributor";
                break;
            }
            case 2: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/navigation/YAMLKeysSearchEverywhereContributor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsRenderer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementsRenderer";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findKeys";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyPattern";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "countDots";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetchElements$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Factory
    implements SearchEverywhereContributorFactory<Language> {
        @NotNull
        public SearchEverywhereContributor<Language> createContributor(AnActionEvent initEvent) {
            YAMLKeysSearchEverywhereContributor yAMLKeysSearchEverywhereContributor = new YAMLKeysSearchEverywhereContributor(initEvent.getProject());
            if (yAMLKeysSearchEverywhereContributor == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return yAMLKeysSearchEverywhereContributor;
        }

        @Nullable
        public SearchEverywhereContributorFilter<Language> createFilter(AnActionEvent initEvent) {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/navigation/YAMLKeysSearchEverywhereContributor$Factory", "createContributor"));
        }
    }
}

