/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.model;

import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import org.jetbrains.annotations.NotNull;

public class StyleState {
    private TextStyle myCurrentStyle = TextStyle.EMPTY;
    private TextStyle myDefaultStyle = TextStyle.EMPTY;
    private TextStyle myMergedStyle = null;

    public StyleState() {
        this(TextStyle.EMPTY);
    }

    public StyleState(TextStyle textStyle) {
        this.myCurrentStyle = textStyle;
    }

    public TextStyle getCurrent() {
        return TextStyle.getCanonicalStyle(this.getMergedStyle());
    }

    private static TextStyle merge(@NotNull TextStyle style, @NotNull TextStyle defaultStyle) {
        TextStyle newStyle = style.clone();
        if (newStyle.getBackground() == null && defaultStyle.getBackground() != null) {
            newStyle.setBackground(defaultStyle.getBackground());
        }
        if (newStyle.getForeground() == null && defaultStyle.getForeground() != null) {
            newStyle.setForeground(defaultStyle.getForeground());
        }
        return newStyle.readonlyCopy();
    }

    public void reset() {
        this.myCurrentStyle = this.myDefaultStyle.clone();
        this.myMergedStyle = null;
    }

    public void set(StyleState styleState) {
        this.setCurrent(styleState.getCurrent());
    }

    public void setDefaultStyle(TextStyle defaultStyle) {
        this.myDefaultStyle = defaultStyle;
        this.myMergedStyle = null;
    }

    public TerminalColor getBackground() {
        return this.getBackground(null);
    }

    public TerminalColor getBackground(TerminalColor color) {
        return color != null ? color : this.myDefaultStyle.getBackground();
    }

    public TerminalColor getForeground() {
        return this.getForeground(null);
    }

    public TerminalColor getForeground(TerminalColor color) {
        return color != null ? color : this.myDefaultStyle.getForeground();
    }

    public StyleState clone() {
        return new StyleState(this.myCurrentStyle);
    }

    public void setCurrent(TextStyle current) {
        this.myCurrentStyle = current;
        this.myMergedStyle = null;
    }

    public TextStyle getMergedStyle() {
        if (this.myMergedStyle == null) {
            this.myMergedStyle = StyleState.merge(this.myCurrentStyle, this.myDefaultStyle);
        }
        return this.myMergedStyle;
    }
}

