/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsMessages;

import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.cvshandlers.CvsMessagePattern;
import com.intellij.cvsSupport2.cvsoperations.common.UpdatedFilesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesListener;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.FileMessage;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.MessageEvent;
import com.intellij.util.PatternUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.command.update.UpdateFileInfo;
import org.netbeans.lib.cvsclient.command.update.UpdatedFileInfo;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.IEntryListener;
import org.netbeans.lib.cvsclient.event.IFileInfoListener;
import org.netbeans.lib.cvsclient.event.IMessageListener;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;

public class CvsMessagesTranslator
implements IFileInfoListener,
IMessageListener,
IEntryListener {
    @NonNls
    private static final CvsMessagePattern[] ERRORS_PATTERNS = new CvsMessagePattern[]{new CvsMessagePattern("cvs [* aborted]*"), new CvsMessagePattern("Usage: cvs* server*"), new CvsMessagePattern("cvs*: invalid option*"), new CvsMessagePattern(new String[]{"cvs checkout: could not check out ", "*"}, 2), new CvsMessagePattern("cvs* update: could not merge revision * of *: No such file or directory"), new CvsMessagePattern(new String[]{"cvs* update: could not patch ", "*", "; will refetch"}, 2), new CvsMessagePattern("dying gasps from * unexpected"), new CvsMessagePattern("end of file from server (consult above messages if any)"), new CvsMessagePattern("\\*PANIC\\* administration files missing"), new CvsMessagePattern(new String[]{"cvs*: Up-to-date check failed for `", "*", "'"}, 2), new CvsMessagePattern("cvs*: cannot add file on non-branch tag *"), new CvsMessagePattern("Cannot access *"), new CvsMessagePattern("error  Permission denied"), new CvsMessagePattern(new String[]{"cvs*: ", "*", " already exists, with version number *"}, 2), new CvsMessagePattern(new String[]{"cvs*: cannot commit with sticky date for file `", "*", "'"}, 2), new CvsMessagePattern(new String[]{"cvs*: nothing known about `", "*", "'"}, 2), new CvsMessagePattern("cvs*: sticky tag `*' for file `*' is not a branch"), new CvsMessagePattern("cvs*: ERROR: cannot mkdir * -- not added: No such file or directory"), new CvsMessagePattern(new String[]{"cvs: nothing known about ", "*"}, 2), new CvsMessagePattern("Root * must be an absolute pathname"), new CvsMessagePattern("protocol error: *"), new CvsMessagePattern("cvs* tag: nothing known about *"), new CvsMessagePattern("cvs* tag: cannot*"), new CvsMessagePattern("cvs* tag:* failed*"), new CvsMessagePattern("cvs* tag: Not removing branch tag `*' from `*,v'."), new CvsMessagePattern("cvs tag: *: Not moving branch tag `*' from * to *."), new CvsMessagePattern(new String[]{"cvs*: failed to create lock directory for `", "*", "' (*/#cvs.lock): No such file or directory"}, 2)};
    private static final CvsMessagePattern[] WARNINGS_PATTERNS = new CvsMessagePattern[]{new CvsMessagePattern("cvs server: cannot open *: Permission denied"), new CvsMessagePattern("cvs server: cannot make path to *: Permission denied"), new CvsMessagePattern("cvs server: cannot find module `*' - ignored"), new CvsMessagePattern("W * : * already exists on version * : NOT MOVING tag to version *"), new CvsMessagePattern("W * : * already exists on branch * : NOT MOVING tag to branch *"), new CvsMessagePattern(new String[]{"cvs server: ", "*", " added independently by second party"}, 2), new CvsMessagePattern("cvs server: failed to create lock directory for `*' (*#cvs.lock): No such file or directory"), new CvsMessagePattern("cvs server: failed to obtain dir lock in repository `*'"), new CvsMessagePattern("cvs*: warning: *")};
    private static final Pattern[] FILE_MESSAGE_PATTERNS = new Pattern[]{PatternUtil.fromMask((String)"cvs*: Updating*"), PatternUtil.fromMask((String)"Directory * added to the repository"), PatternUtil.fromMask((String)"cvs*: scheduling file `*' for addition"), PatternUtil.fromMask((String)"cvs *: [*] waiting for *'s lock in *"), PatternUtil.fromMask((String)"RCS file: *,v"), PatternUtil.fromMask((String)"cvs*: Tagging*"), PatternUtil.fromMask((String)"cvs add: scheduling file `*' for addition"), PatternUtil.fromMask((String)"cvs rlog: Logging*")};
    private static final Pattern[] MESSAGE_PATTERNS = new Pattern[]{PatternUtil.fromMask((String)"cvs *: [*] waiting for *'s lock in *")};
    private final CvsMessagesListener myListener;
    private final ICvsFileSystem myCvsFileSystem;
    private final UpdatedFilesManager myUpdatedFilesManager;
    private final String myCvsRoot;
    private final Map<File, Object> myFileToInfoMap = new HashMap<File, Object>();
    private final Collection<String> myPreviousErrorMessages = new ArrayList<String>();
    @NonNls
    private static final String CORRECT_ABOVE_ERRORS_FIRST_PREFIX = "correct above errors first";
    private MessageType lastMessage = null;

    public CvsMessagesTranslator(CvsMessagesListener listener, ICvsFileSystem cvsFileSystem, UpdatedFilesManager mergedFilesCollector, String cvsroot) {
        this.myListener = listener;
        this.myCvsFileSystem = cvsFileSystem;
        this.myUpdatedFilesManager = mergedFilesCollector;
        this.myCvsRoot = cvsroot;
    }

    public void fileInfoGenerated(Object info) {
        UpdatedFileInfo updatedFileInfo;
        File file;
        if (info instanceof UpdateFileInfo) {
            UpdateFileInfo updateFileInfo = (UpdateFileInfo)info;
            File file2 = updateFileInfo.getFile();
            if (!this.myUpdatedFilesManager.fileIsNotUpdated(file2) && !this.myFileToInfoMap.containsKey(file2)) {
                this.myFileToInfoMap.put(file2, updateFileInfo);
            }
        } else if (info instanceof UpdatedFileInfo && !this.myUpdatedFilesManager.fileIsNotUpdated(file = (updatedFileInfo = (UpdatedFileInfo)info).getFile())) {
            this.myFileToInfoMap.put(file, updatedFileInfo);
        }
    }

    public void gotEntry(FileObject fileObject, Entry entry) {
    }

    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        this.myListener.addMessage(new MessageEvent(message, error, tagged));
        if (message.isEmpty()) {
            return;
        }
        if (CvsMessagesTranslator.isFileMessage(message)) {
            this.lastMessage = MessageType.FILE_MESSAGE;
            this.myListener.addFileMessage(message, this.myCvsFileSystem);
            return;
        }
        if (CvsMessagesTranslator.isMessage(message)) {
            this.lastMessage = MessageType.MESSAGE;
            this.myListener.addMessage(message);
            return;
        }
        CvsMessagePattern errorMessagePattern = CvsMessagesTranslator.getErrorMessagePattern(message, ERRORS_PATTERNS);
        if (errorMessagePattern != null) {
            if (message.contains(CORRECT_ABOVE_ERRORS_FIRST_PREFIX)) {
                for (String s : this.myPreviousErrorMessages) {
                    this.myListener.addError(s, null, this.myCvsFileSystem, this.myCvsRoot, false);
                }
                this.myPreviousErrorMessages.clear();
                return;
            }
            String relativeFileName = errorMessagePattern.getRelativeFileName(message);
            this.lastMessage = MessageType.ERROR;
            this.myListener.addError(message, relativeFileName, this.myCvsFileSystem, this.myCvsRoot, false);
            return;
        }
        CvsMessagePattern warningMessagePattern = CvsMessagesTranslator.getErrorMessagePattern(message, WARNINGS_PATTERNS);
        if (warningMessagePattern != null) {
            this.lastMessage = MessageType.WARNING;
            this.myListener.addError(message, warningMessagePattern.getRelativeFileName(message), this.myCvsFileSystem, this.myCvsRoot, true);
            return;
        }
        if (message.trim().isEmpty()) {
            return;
        }
        if (this.lastMessage == MessageType.ERROR) {
            this.myListener.addError(message, null, this.myCvsFileSystem, this.myCvsRoot, false);
        } else if (this.lastMessage == MessageType.WARNING) {
            this.myListener.addError(message, null, this.myCvsFileSystem, this.myCvsRoot, true);
        } else if (error) {
            this.myPreviousErrorMessages.add(message);
        }
    }

    private static boolean isFileMessage(String message) {
        for (Pattern pattern : FILE_MESSAGE_PATTERNS) {
            if (!pattern.matcher(message).matches()) continue;
            return true;
        }
        return false;
    }

    private static boolean isMessage(String message) {
        for (Pattern pattern : MESSAGE_PATTERNS) {
            if (!pattern.matcher(message).matches()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static CvsMessagePattern getErrorMessagePattern(String message, CvsMessagePattern[] patterns) {
        for (CvsMessagePattern pattern : patterns) {
            if (!pattern.matches(message)) continue;
            return pattern;
        }
        return null;
    }

    public void registerTo(EventManager eventManager) {
        eventManager.addFileInfoListener((IFileInfoListener)this);
        eventManager.addMessageListener((IMessageListener)this);
    }

    public void operationCompleted() {
        if (!CvsEntriesManager.getInstance().isActive()) {
            return;
        }
        for (File file : this.myFileToInfoMap.keySet()) {
            this.addFileMessage(this.myFileToInfoMap.get(file), file);
        }
    }

    private void addFileMessage(Object info, File file) {
        if (info instanceof UpdateFileInfo) {
            this.addUpdateFileInfo(file, (UpdateFileInfo)info);
        } else if (info instanceof UpdatedFileInfo) {
            this.addUpdatedFileInfo(file, (UpdatedFileInfo)info);
        }
    }

    private void addUpdatedFileInfo(File file, UpdatedFileInfo updatedFileInfo) {
        if (!this.myUpdatedFilesManager.fileIsNotUpdated(file)) {
            this.myListener.addFileMessage(new FileMessage(updatedFileInfo, this.myUpdatedFilesManager));
        }
    }

    private void addUpdateFileInfo(File file, UpdateFileInfo updateFileInfo) {
        if (!this.myUpdatedFilesManager.fileIsNotUpdated(file)) {
            this.myListener.addFileMessage(new FileMessage(updateFileInfo, this.myUpdatedFilesManager, this.myUpdatedFilesManager));
        }
    }

    public void binaryMessageSent(byte[] bytes) {
    }

    static enum MessageType {
        MESSAGE,
        FILE_MESSAGE,
        WARNING,
        ERROR;

    }
}

