/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddWslNodeInterpreterDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(AddWslNodeInterpreterDialog.class);
    private static volatile File myWhichNodeShellScriptFile;
    private static volatile File myListNodesShellScriptFile;
    private final CollectionComboBoxModel<WslDistId> myDistComboBoxModel;
    private final ComboBox<WslDistId> myDistComboBox;
    private final TextFieldWithHistory myNodePathComponent;
    private final JPanel myPanel;
    private final Map<WslDistId, List<String>> myCachedInterpreters;
    private final Map<WslDistId, Ref<String>> myLatestWslNodePath;
    private final WslNodeInterpreterManager.Distributions myAvailableDistributions;
    private boolean myValidateNodePath;
    private String myAutoDetectedNodePath;

    protected AddWslNodeInterpreterDialog(@NotNull Project project, @Nullable WslNodeInterpreter interpreter) {
        if (project == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myCachedInterpreters = ContainerUtil.newHashMap();
        this.myLatestWslNodePath = ContainerUtil.newHashMap();
        this.myValidateNodePath = false;
        this.myAutoDetectedNodePath = "";
        this.setTitle((interpreter != null ? "Edit" : "Add") + " WSL Node Interpreter");
        this.myAvailableDistributions = WslNodeInterpreterManager.getInstance().updateAvailableDistributionsAndGet();
        List wslDistIds = ContainerUtil.map(this.myAvailableDistributions.getDistributions(), distribution -> new WslDistId(distribution.getId()));
        this.myDistComboBoxModel = new CollectionComboBoxModel((List)ContainerUtil.newArrayList((Iterable)wslDistIds));
        this.myDistComboBox = new ComboBox();
        this.myDistComboBox.setModel(this.myDistComboBoxModel);
        this.myDistComboBox.setRenderer((ListCellRenderer)((Object)new WslDistributionRenderer()));
        this.myNodePathComponent = new TextFieldWithHistory();
        this.myNodePathComponent.setEditor((ComboBoxEditor)new FixedComboBoxEditor());
        this.myNodePathComponent.setHistorySize(-1);
        this.myDistComboBox.addItemListener(e -> {
            WslDistId prevDist;
            this.myValidateNodePath = false;
            if (e.getStateChange() == 1) {
                this.updateNodePathOnDistributionChanged((WslDistId)ObjectUtils.tryCast((Object)e.getItem(), WslDistId.class));
            } else if (e.getStateChange() == 2 && (prevDist = (WslDistId)ObjectUtils.tryCast((Object)e.getItem(), WslDistId.class)) != null) {
                this.myLatestWslNodePath.put(prevDist, (Ref<String>)Ref.create((Object)this.myNodePathComponent.getText()));
            }
        });
        if (interpreter == null) {
            this.updateNodePathOnDistributionChanged((WslDistId)this.myDistComboBoxModel.getSelected());
        } else {
            this.myDistComboBoxModel.setSelectedItem((Object)new WslDistId(interpreter.getWslDistributionId()));
            this.setNodePath(interpreter.getWslInterpreterPath());
        }
        this.loadAvailableInterpretersOnExpansion(this.myNodePathComponent);
        FormBuilder formBuilder = new FormBuilder(){

            protected int getFill(JComponent component) {
                return 2;
            }
        };
        this.myPanel = formBuilder.setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent("Linux &Distribution:", this.myDistComboBox).addLabeledComponent("WSL &Node Interpreter:", (JComponent)this.myNodePathComponent).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
        this.configurePreferredWidth();
        this.init();
    }

    private void updateNodePathOnDistributionChanged(@Nullable WslDistId selected) {
        String text = StringUtil.notNullize((String)this.myNodePathComponent.getText());
        if (!text.isEmpty() && !text.equals(this.myAutoDetectedNodePath)) {
            return;
        }
        this.setNodePath("");
        StatusText emptyText = this.getNodePathEmptyText();
        if (emptyText != null) {
            emptyText.clear();
        }
        if (selected == null) {
            return;
        }
        Ref<String> lastPathRef = this.myLatestWslNodePath.get(selected);
        if (lastPathRef != null) {
            if (!lastPathRef.isNull()) {
                this.setNodePath((String)lastPathRef.get());
            }
            return;
        }
        WSLDistribution distribution = this.myAvailableDistributions.findById(selected.myId);
        if (emptyText != null && distribution != null) {
            emptyText.setText("Running `which node`...");
            this.myLatestWslNodePath.put(selected, (Ref<String>)Ref.create());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String whichNodeResult = AddWslNodeInterpreterDialog.runWhichNode(distribution);
                ApplicationManager.getApplication().invokeLater(() -> {
                    Ref<String> last = Objects.requireNonNull(this.myLatestWslNodePath.get(selected));
                    if (last.get() != null) {
                        return;
                    }
                    if (this.myNodePathComponent.isShowing() && selected.equals(this.myDistComboBoxModel.getSelected())) {
                        emptyText.clear();
                        if (whichNodeResult != null && StringUtil.isEmpty((String)this.myNodePathComponent.getText())) {
                            this.setNodePath(whichNodeResult);
                            this.myAutoDetectedNodePath = whichNodeResult;
                        }
                    }
                }, ModalityState.any());
            });
        }
    }

    private void setNodePath(@NotNull String wslNodePath) {
        if (wslNodePath == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(1);
        }
        this.myNodePathComponent.setSelectedItem((Object)wslNodePath);
    }

    @Nullable
    private StatusText getNodePathEmptyText() {
        JBTextField field = (JBTextField)ObjectUtils.tryCast((Object)this.myNodePathComponent.getTextEditor(), JBTextField.class);
        return field != null ? field.getEmptyText() : null;
    }

    public void loadAvailableInterpretersOnExpansion(final @NotNull TextFieldWithHistory textFieldWithHistory) {
        if (textFieldWithHistory == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(2);
        }
        textFieldWithHistory.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                WslDistId selected = (WslDistId)AddWslNodeInterpreterDialog.this.myDistComboBoxModel.getSelected();
                if (selected == null) {
                    AddWslNodeInterpreterDialog.this.setAvailableNodePaths(Collections.emptyList());
                    return;
                }
                List paths = (List)AddWslNodeInterpreterDialog.this.myCachedInterpreters.get(selected);
                if (paths != null) {
                    AddWslNodeInterpreterDialog.this.setAvailableNodePaths(paths);
                    return;
                }
                WSLDistribution distribution = AddWslNodeInterpreterDialog.this.myAvailableDistributions.findById(selected.myId);
                if (distribution == null) {
                    return;
                }
                AddWslNodeInterpreterDialog.this.setAvailableNodePaths(Collections.emptyList());
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    if (textFieldWithHistory == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    List history = AddWslNodeInterpreterDialog.getAvailableInterpreters(distribution);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (textFieldWithHistory == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        AddWslNodeInterpreterDialog.this.myCachedInterpreters.put(selected, history);
                        if (selected.equals(AddWslNodeInterpreterDialog.this.myDistComboBoxModel.getSelected()) && textFieldWithHistory.isShowing()) {
                            AddWslNodeInterpreterDialog.this.setAvailableNodePaths(history);
                            if (textFieldWithHistory.isPopupVisible()) {
                                textFieldWithHistory.setPopupVisible(false);
                                textFieldWithHistory.setPopupVisible(true);
                            }
                        }
                    }, ModalityState.any());
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "textFieldWithHistory";
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/AddWslNodeInterpreterDialog$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$popupMenuWillBecomeVisible$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void setAvailableNodePaths(@NotNull List<String> availableNodePaths) {
        if (availableNodePaths == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(3);
        }
        SwingHelper.setHistory((TextFieldWithHistory)this.myNodePathComponent, availableNodePaths, (boolean)false);
    }

    @Nullable
    private static String runWhichNode(@NotNull WSLDistribution distribution) {
        if (distribution == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(4);
        }
        try {
            String prefix = "node_path_start:";
            String suffix = ":node_path_end";
            File whichNodeShellScriptFile = AddWslNodeInterpreterDialog.getOrCreateWhichNodeShellScriptFile(prefix, suffix);
            if (whichNodeShellScriptFile == null) {
                return null;
            }
            String scriptPath = distribution.getWslPath(whichNodeShellScriptFile.getAbsolutePath());
            ProcessOutput output = distribution.executeOnWsl(5000, new String[]{"$SHELL", "-i", "-c", scriptPath});
            String stdout = output.getStdout();
            int startInd = stdout.indexOf(prefix);
            int endInd = stdout.indexOf(suffix, startInd);
            if (startInd >= 0 && endInd > 0) {
                return stdout.substring(startInd + prefix.length(), endInd);
            }
            return null;
        }
        catch (ExecutionException ignored) {
            return null;
        }
    }

    @Nullable
    private static File getOrCreateWhichNodeShellScriptFile(@NotNull String prefix, @NotNull String suffix) {
        File file2;
        if (prefix == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(5);
        }
        if (suffix == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(6);
        }
        if ((file2 = myWhichNodeShellScriptFile) == null) {
            myWhichNodeShellScriptFile = file2 = AddWslNodeInterpreterDialog.writeFile("which-node.sh", (ThrowableComputable<String, IOException>)((ThrowableComputable)() -> {
                if (prefix == null) {
                    AddWslNodeInterpreterDialog.$$$reportNull$$$0(14);
                }
                if (suffix == null) {
                    AddWslNodeInterpreterDialog.$$$reportNull$$$0(15);
                }
                return "echo '" + prefix + "'$(which node)'" + suffix + "'";
            }));
        }
        return file2;
    }

    @NotNull
    private static List<String> getAvailableInterpreters(@NotNull WSLDistribution distribution) {
        List<String> list;
        File installationFile;
        HashSet lines;
        String prefix;
        block8: {
            if (distribution == null) {
                AddWslNodeInterpreterDialog.$$$reportNull$$$0(7);
            }
            prefix = "node_path:";
            lines = ContainerUtil.newHashSet();
            installationFile = AddWslNodeInterpreterDialog.getFileListingInstallations();
            if (installationFile != null) break block8;
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                AddWslNodeInterpreterDialog.$$$reportNull$$$0(8);
            }
            return list2;
        }
        try {
            ProcessOutput output = distribution.executeOnWsl(5000, new String[]{distribution.getWslPath(installationFile.getAbsolutePath())});
            for (String line : output.getStdoutLines()) {
                String path;
                if (!line.startsWith(prefix) || (path = line.substring(prefix.length()).trim()).isEmpty()) continue;
                lines.add(path);
            }
            list = lines.stream().sorted().collect(Collectors.toList());
        }
        catch (ExecutionException ignored) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                AddWslNodeInterpreterDialog.$$$reportNull$$$0(10);
            }
            return list3;
        }
        if (list == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static File getFileListingInstallations() {
        VirtualFile file2;
        File result2 = myListNodesShellScriptFile;
        if (result2 != null) {
            return result2;
        }
        long startTime = System.nanoTime();
        String name = "find_node_installations.sh";
        URL url = AddWslNodeInterpreterDialog.class.getResource(name);
        if (url == null) {
            LOG.error("Installation is possibly broken. Cannot find " + name);
            return null;
        }
        SettableFuture future = SettableFuture.create();
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                future.set(WriteAction.compute(() -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtilCore.convertFromUrl((URL)url))));
            }
            catch (Throwable e) {
                future.setException(e);
            }
        }, ModalityState.any());
        try {
            file2 = (VirtualFile)future.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOG.error("Cannot refresh " + url, (Throwable)e);
            return null;
        }
        if (file2 == null || !file2.isValid()) {
            LOG.error("Cannot refreshAndFind " + url);
            return null;
        }
        myListNodesShellScriptFile = result2 = AddWslNodeInterpreterDialog.writeFile(name, (ThrowableComputable<String, IOException>)((ThrowableComputable)() -> VfsUtilCore.loadText((VirtualFile)file2)));
        if (result2 != null) {
            LOG.info(result2.getAbsolutePath() + " written in " + TimeoutUtil.getDurationMillis((long)startTime) + " ms");
        }
        return result2;
    }

    @Nullable
    private static File writeFile(@NotNull String name, @NotNull ThrowableComputable<String, IOException> textComputable) {
        if (name == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(11);
        }
        if (textComputable == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(12);
        }
        try {
            String extension = FileUtilRt.getExtension((String)name);
            if (!extension.isEmpty()) {
                extension = "." + extension;
            }
            File file2 = FileUtil.createTempFile((String)FileUtil.getNameWithoutExtension((String)name), (String)extension, (boolean)true);
            String text = (String)textComputable.compute();
            text = StringUtil.convertLineSeparators((String)text, (String)LineSeparator.LF.getSeparatorString());
            FileUtil.writeToFile((File)file2, (String)text);
            return file2;
        }
        catch (IOException e) {
            LOG.error("Cannot write temp file " + name);
            return null;
        }
    }

    private void configurePreferredWidth() {
        this.myNodePathComponent.setMinimumAndPreferredWidth(-1);
        SwingHelper.setPreferredWidth((Component)this.myNodePathComponent, (int)JBUI.scale((int)400));
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        WslDistId distId = (WslDistId)this.myDistComboBoxModel.getSelected();
        if (distId == null || this.myAvailableDistributions.findById(distId.myId) == null) {
            return new ValidationInfo("Please select a distribution", this.myDistComboBox);
        }
        if (this.myValidateNodePath && this.myNodePathComponent.getText().isEmpty()) {
            return new ValidationInfo("Please specify WSL path to Node.js interpreter", (JComponent)this.myNodePathComponent);
        }
        return null;
    }

    @NotNull
    protected Action getOKAction() {
        DialogWrapper.OkAction okAction = new DialogWrapper.OkAction(){

            protected void doAction(ActionEvent e) {
                AddWslNodeInterpreterDialog.this.myValidateNodePath = true;
                super.doAction(e);
            }
        };
        if (okAction == null) {
            AddWslNodeInterpreterDialog.$$$reportNull$$$0(13);
        }
        return okAction;
    }

    @Nullable
    public WslNodeInterpreter showAndGetInterpreter() {
        if (this.showAndGet()) {
            WslDistId distribution = (WslDistId)this.myDistComboBoxModel.getSelected();
            String path = this.myNodePathComponent.getText();
            if (distribution != null && StringUtil.isNotEmpty((String)path)) {
                return new WslNodeInterpreter(distribution.myId, path);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslNodePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldWithHistory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableNodePaths";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/AddWslNodeInterpreterDialog";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComputable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/AddWslNodeInterpreterDialog";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableInterpreters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNodePath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadAvailableInterpretersOnExpansion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAvailableNodePaths";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runWhichNode";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateWhichNodeShellScriptFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableInterpreters";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOrCreateWhichNodeShellScriptFile$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class WslDistributionRenderer
    extends ColoredListCellRenderer<WslDistId> {
        private WslDistributionRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends WslDistId> list, @Nullable WslDistId value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                WslDistributionRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                this.append("No available distributions");
                return;
            }
            WSLDistribution distribution = AddWslNodeInterpreterDialog.this.myAvailableDistributions.findById(value.myId);
            if (distribution != null) {
                this.append(distribution.getPresentableName());
                this.append("  ");
                this.append(distribution.getExecutablePath().getFileName().toString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else {
                this.append(value.myId + " is unavailable");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/interpreter/wsl/AddWslNodeInterpreterDialog$WslDistributionRenderer", "customizeCellRenderer"));
        }
    }

    private static class WslDistId {
        private final String myId;

        private WslDistId(@NotNull String id) {
            if (id == null) {
                WslDistId.$$$reportNull$$$0(0);
            }
            this.myId = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WslDistId id = (WslDistId)o;
            return Objects.equals(this.myId, id.myId);
        }

        public int hashCode() {
            return Objects.hash(this.myId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/javascript/nodejs/interpreter/wsl/AddWslNodeInterpreterDialog$WslDistId", "<init>"));
        }
    }
}

