/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.ide.IdeView;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import icons.JavaScriptLanguageIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonNewFileAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(PackageJsonNewFileAction.class);

    public PackageJsonNewFileAction() {
        super("package.json File", "Creates a package.json file", JavaScriptLanguageIcons.Nodejs.Nodejs);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiDirectory psiDir;
        if (e == null) {
            PackageJsonNewFileAction.$$$reportNull$$$0(0);
        }
        if ((psiDir = PackageJsonNewFileAction.getPsiDirectory(e)) != null && psiDir.isValid()) {
            try {
                PackageJsonUtil.createPackageJson(psiDir, true);
            }
            catch (RuntimeException ex) {
                LOG.error("Cannot create package.json", (Throwable)ex);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile virtualDir;
        PsiDirectory psiDir;
        if (e == null) {
            PackageJsonNewFileAction.$$$reportNull$$$0(1);
        }
        boolean available = false;
        Project project = e.getProject();
        if (project != null && (psiDir = PackageJsonNewFileAction.getPsiDirectory(e)) != null && psiDir.isValid() && (virtualDir = psiDir.getVirtualFile()).isValid() && virtualDir.isDirectory() && virtualDir.findChild("package.json") == null) {
            available = true;
        }
        e.getPresentation().setEnabledAndVisible(available);
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(AnActionEvent e) {
        PsiDirectory[] directories;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null && (directories = view.getDirectories()).length == 1) {
            return directories[0];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonNewFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

