/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopularPackageListGenerator {
    private static final String MOST_DEPENDED_UPON_PACKAGES_DIR = "most-depended-upon-packages";
    private static final String MOST_STARRED_PACKAGES_DIR = "most-starred-packages";
    private static final int PACKAGES_PER_PAGE = 36;
    private static final int N = 1000;

    public static void main(String[] args) throws IOException {
        File downloadRoot = PopularPackageListGenerator.download();
        List<NodePackageBasicInfo> infos = PopularPackageListGenerator.parseAll(downloadRoot);
        PopularPackageListGenerator.writePackages(infos, new File(downloadRoot, "popular-node-packages.json"));
    }

    private static File download() throws IOException {
        File baseDir = FileUtil.createTempDirectory((String)"popular-node-packages-data", null, (boolean)false);
        if (!baseDir.isDirectory()) {
            throw new RuntimeException("Not a directory: " + baseDir.getAbsolutePath());
        }
        PopularPackageListGenerator.download("https://www.npmjs.com/browse/depended?offset=%d", new File(baseDir, MOST_DEPENDED_UPON_PACKAGES_DIR));
        PopularPackageListGenerator.download("https://www.npmjs.com/browse/star?offset=%d", new File(baseDir, MOST_STARRED_PACKAGES_DIR));
        return baseDir;
    }

    private static void download(@NotNull String urlPrefix, @NotNull File dir) throws IOException {
        if (urlPrefix == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(1);
        }
        PopularPackageListGenerator.log("\n=== Downloading to " + dir.getAbsolutePath() + " ===", new Object[0]);
        for (int i = 0; i < 28; ++i) {
            int finalInd = i;
            String url = String.format(urlPrefix, i * 36);
            long startNano = System.nanoTime();
            RequestBuilder requestBuilder = HttpRequests.request((String)url);
            requestBuilder.connectTimeout(10000);
            requestBuilder.readTimeout(10000);
            boolean ok = false;
            int attempts = 0;
            while (!ok && attempts < 10) {
                int finalAttempts = attempts++;
                ok = (Boolean)requestBuilder.connect(request -> {
                    void request2;
                    if (dir == null) {
                        PopularPackageListGenerator.$$$reportNull$$$0(11);
                    }
                    String content = request2.readString(null);
                    HttpURLConnection connection = (HttpURLConnection)ObjectUtils.tryCast((Object)request2.getConnection(), HttpURLConnection.class);
                    int responseCode = Objects.requireNonNull(connection).getResponseCode();
                    File file2 = new File(dir, finalInd + ".html");
                    PopularPackageListGenerator.log("Downloaded in %d ms, content: %s, %s, response: %d, attempts: %d, file: %s, ", TimeoutUtil.getDurationMillis((long)startNano), content.length(), url, responseCode, finalAttempts, file2.getName());
                    FileUtil.writeToFile((File)file2, (String)content);
                    TimeoutUtil.sleep((long)1000L);
                    List<NodePackageBasicInfo> infos = PopularPackageListGenerator.parsedInfos(content);
                    return infos.size() > 0;
                });
            }
        }
    }

    private static void log(String format, Object ... args) {
        System.out.printf(format + "\n", args);
    }

    @NotNull
    public static List<NodePackageBasicInfo> parseAll(@NotNull File downloadRoot) throws IOException {
        if (downloadRoot == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(2);
        }
        List<NodePackageBasicInfo> mostDependedUponInfos = PopularPackageListGenerator.parse(new File(downloadRoot, MOST_DEPENDED_UPON_PACKAGES_DIR));
        List<NodePackageBasicInfo> mostStarredInfos = PopularPackageListGenerator.parse(new File(downloadRoot, MOST_STARRED_PACKAGES_DIR));
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (NodePackageBasicInfo info : mostDependedUponInfos) {
            map.put(info.getName(), info);
        }
        for (NodePackageBasicInfo info : mostStarredInfos) {
            NodePackageBasicInfo old = (NodePackageBasicInfo)map.get(info.getName());
            if (old == null) {
                map.put(info.getName(), info);
                continue;
            }
            if (old.equals(info)) continue;
            throw new RuntimeException("Different packages: " + old + " vs " + info);
        }
        PopularPackageListGenerator.log("", new Object[0]);
        PopularPackageListGenerator.log("      Most starred: " + mostStarredInfos.size(), new Object[0]);
        PopularPackageListGenerator.log("Most depended upon: " + mostDependedUponInfos.size(), new Object[0]);
        PopularPackageListGenerator.log("        Total size: " + (mostStarredInfos.size() + mostDependedUponInfos.size()), new Object[0]);
        PopularPackageListGenerator.log(" Total merged size: " + map.size(), new Object[0]);
        List<NodePackageBasicInfo> list = map.values().stream().limit(1000L).collect(Collectors.toList());
        if (list == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> parse(@NotNull File dir) throws IOException {
        if (dir == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(4);
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException();
        }
        File[] files = (File[])ObjectUtils.notNull((Object)dir.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY);
        Arrays.sort(files, (o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            int id1 = Integer.parseInt(FileUtil.getNameWithoutExtension((String)name1));
            int id2 = Integer.parseInt(FileUtil.getNameWithoutExtension((String)name2));
            return id1 - id2;
        });
        ArrayList infos = ContainerUtil.newArrayList();
        HashSet names = ContainerUtil.newHashSet();
        for (File file2 : files) {
            PopularPackageListGenerator.log("Parsing " + file2.getAbsolutePath(), new Object[0]);
            String content = FileUtil.loadFile((File)file2);
            List<NodePackageBasicInfo> parsed = PopularPackageListGenerator.parsedInfos(content);
            for (NodePackageBasicInfo info : parsed) {
                if (names.contains(info.getName())) {
                    throw new RuntimeException("Duplicated name " + info.getName());
                }
                infos.add(info);
            }
        }
        ArrayList arrayList = infos;
        if (arrayList == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<NodePackageBasicInfo> parsedInfos(@NotNull String content) {
        Matcher matcher;
        if (content == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(6);
        }
        if (!(matcher = Pattern.compile("<script integrity=\"[^\"]*\">").matcher(content)).find()) {
            throw new RuntimeException("Cannot find script content");
        }
        int start = matcher.end();
        int end = content.indexOf("</script>", start);
        if (start == -1 || end == -1) {
            throw new RuntimeException("Cannot find script content");
        }
        String inner = content.substring(start, end);
        int startObj = inner.indexOf(123);
        if (startObj == -1) {
            throw new RuntimeException("Cannot find script content");
        }
        JsonElement element = new JsonParser().parse(inner.substring(startObj));
        JsonArray packages = element.getAsJsonObject().getAsJsonObject("context").getAsJsonArray("packages");
        if (packages == null) {
            System.err.println("No packages");
            List<NodePackageBasicInfo> list = Collections.emptyList();
            if (list == null) {
                PopularPackageListGenerator.$$$reportNull$$$0(7);
            }
            return list;
        }
        ArrayList infos = ContainerUtil.newArrayList();
        for (JsonElement pkg : packages) {
            JsonObject obj = pkg.getAsJsonObject();
            String name = JsonUtil.getChildAsString((JsonObject)obj, (String)"name");
            String description = JsonUtil.getChildAsString((JsonObject)obj, (String)"description");
            NodePackageBasicInfo info = new NodePackageBasicInfo(Objects.requireNonNull(name), PopularPackageListGenerator.normalizeDescription(description));
            infos.add(info);
        }
        ArrayList arrayList = infos;
        if (arrayList == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    private static String normalizeDescription(@Nullable String description) {
        if (description == null) {
            return null;
        }
        if (!(description = StringEscapeUtils.unescapeHtml((String)description)).contains(". ")) {
            description = StringUtil.trimEnd((String)description, (String)".");
        }
        if (description.startsWith("[![")) {
            return null;
        }
        return description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePackages(@NotNull List<NodePackageBasicInfo> names, @NotNull File outputFile) throws IOException {
        if (names == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(9);
        }
        if (outputFile == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(10);
        }
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));){
            writer.setIndent(" ");
            writer.beginArray();
            for (NodePackageBasicInfo info : names) {
                writer.beginArray();
                writer.setIndent("");
                writer.value(info.getName());
                if (info.getDescription() != null) {
                    writer.value(info.getDescription());
                }
                writer.endArray();
                writer.setIndent(" ");
            }
            writer.endArray();
        }
        PopularPackageListGenerator.log(names.size() + " packages are written to " + outputFile.getAbsolutePath(), new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPrefix";
                break;
            }
            case 1: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadRoot";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAll";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parsedInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseAll";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parsedInfos";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writePackages";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$download$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

