/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.FlowJSToolWindowProvider;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FlowJSServerService
extends JSAsyncLanguageServiceBase
implements JSLanguageService {
    public static final Condition<VirtualFile> FILES_TO_PROCESS = virtualFile -> {
        if (virtualFile == null) {
            return false;
        }
        FileType type = virtualFile.getFileType();
        return DialectDetector.JAVASCRIPT_FILE_TYPES.contains(type) && virtualFile.isInLocalFileSystem() && virtualFile.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER) == null;
    };
    protected static final long COMPLETION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    protected static final long TYPEOF_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(2L);
    protected static final long DEFINITION_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    @NotNull
    protected final FlowJSConfig myConfig;

    public FlowJSServerService(@NotNull FlowJSConfig config2, @NotNull Project project, @NotNull String consoleId) {
        if (config2 == null) {
            FlowJSServerService.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(1);
        }
        if (consoleId == null) {
            FlowJSServerService.$$$reportNull$$$0(2);
        }
        super(project, consoleId);
        this.myConfig = config2;
    }

    @Override
    @NotNull
    protected String getProcessName() {
        if ("Flow" == null) {
            FlowJSServerService.$$$reportNull$$$0(3);
        }
        return "Flow";
    }

    @Override
    @Nullable
    protected JSLanguageServiceToolWindowManager createToolWindow(Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        return FlowJSToolWindowProvider.getToolWindow(project);
    }

    @Nullable
    public abstract PsiElement getDefinitionOfElement(@NotNull Document var1, @NotNull PsiElement var2);

    @Nullable
    public abstract PsiElement findModuleOfElement(@NotNull Document var1, @NotNull PsiElement var2);

    @Nullable
    protected PsiElement getElementByPosition(@NotNull VirtualFile virtualFile, int line, int column) {
        PsiFile psiFile;
        if (virtualFile == null) {
            FlowJSServerService.$$$reportNull$$$0(4);
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile)) == null) {
            return null;
        }
        if (line == -1) {
            return psiFile;
        }
        FileViewProvider provider2 = PsiManager.getInstance((Project)this.myProject).findViewProvider(virtualFile);
        if (provider2 == null) {
            return null;
        }
        Document document = provider2.getDocument();
        if (document == null) {
            return null;
        }
        int offset = document.getLineStartOffset(line) + column;
        PsiElement elementAtOffset = psiFile.findElementAt(offset);
        if (elementAtOffset == null) {
            return null;
        }
        PsiElement meaningfulElement = PsiTreeUtil.findFirstParent((PsiElement)elementAtOffset, (boolean)false, t -> t instanceof JSVarStatement || t instanceof PsiNamedElement);
        if (meaningfulElement instanceof JSVarStatement) {
            JSInitializerOwner declaration = (JSInitializerOwner)ArrayUtil.getFirstElement((Object[])((JSVarStatement)meaningfulElement).getDeclarations());
            return declaration != null ? declaration : meaningfulElement;
        }
        return meaningfulElement != null ? meaningfulElement : elementAtOffset;
    }

    @Nullable
    public String getTypeOfElementUnderProgress(@NotNull JSElement element) {
        if (element == null) {
            FlowJSServerService.$$$reportNull$$$0(5);
        }
        return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (element == null) {
                FlowJSServerService.$$$reportNull$$$0(13);
            }
            try {
                return (String)ReadAction.compute(() -> {
                    if (element == null) {
                        FlowJSServerService.$$$reportNull$$$0(14);
                    }
                    return this.getTypeOfElement(element);
                });
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, "Flow JS:Get Type", true, element.getProject());
    }

    @Nullable
    protected abstract String getTypeOfElement(@NotNull JSElement var1);

    public abstract void beforeCompletion(@NotNull CompletionInitializationContext var1);

    @NotNull
    public static List<FlowJSSettings.FlowJSExecutable> calcPossibleFlowExecutableFiles(Project project) {
        ArrayList paths = ContainerUtil.newArrayList();
        ArrayList infos = ContainerUtil.newArrayList();
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter();
        NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)infos, "flow-bin", project.getBaseDir(), true, interpreter);
        for (CompletionModuleInfo info : infos) {
            VirtualFile moduleDir = info.getVirtualFile();
            if (moduleDir == null) continue;
            File moduleFile = VfsUtilCore.virtualToIoFile((VirtualFile)moduleDir);
            paths.add(new FlowJSSettings.FlowJSExecutable(moduleFile));
        }
        if (paths.isEmpty()) {
            String execFileName = FlowJSServerService.getFlowExecutableFilename();
            List files = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)execFileName);
            for (File file2 : files) {
                paths.add(new FlowJSSettings.FlowJSExecutable(file2));
            }
        }
        ArrayList arrayList = paths;
        if (arrayList == null) {
            FlowJSServerService.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    static String getFlowExecutableFilename() {
        String string = SystemInfo.isWindows ? "flow.exe" : "flow";
        if (string == null) {
            FlowJSServerService.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String isFlowServerAvailable(@Nullable FlowJSSettings.FlowJSExecutable flowJSExecutable, @NotNull Project project) {
        if (project == null) {
            FlowJSServerService.$$$reportNull$$$0(8);
        }
        if (flowJSExecutable == null) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error.empty", (Object[])new Object[0]);
        }
        CompletableFuture<String> future = flowJSExecutable.getVersionFuture();
        flowJSExecutable.evaluateVersionAsync(project);
        try {
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{"Process doesn't respond"});
        }
        catch (ExecutionException e) {
            return e.getCause().getMessage();
        }
        catch (InterruptedException e) {
            return JSBundle.message((String)"js.flow.enable.flow.service.error.on.checking", (Object[])new Object[]{"Checking interrupted"});
        }
        return null;
    }

    @NotNull
    public abstract Map<String, String> getCompletionOfElement(@NotNull PsiFile var1, @NotNull Document var2, @NotNull CompletionParameters var3, @NotNull String var4);

    @NotNull
    public abstract List<JSAnnotationError> getAllErrors();

    @NotNull
    public abstract List<JSAnnotationError> getCoverageOfFile(@NotNull PsiFile var1);

    @NotNull
    public FlowJSConfig getConfig() {
        FlowJSConfig flowJSConfig = this.myConfig;
        if (flowJSConfig == null) {
            FlowJSServerService.$$$reportNull$$$0(9);
        }
        return flowJSConfig;
    }

    public boolean isServiceStarted() {
        if (!this.checkCanUseService()) {
            return false;
        }
        JSLanguageServiceExecutor process = this.getProcess();
        return process != null && process.getState() == JSLanguageServiceExecutor.State.STARTED;
    }

    @Nullable
    public static String getTypeIfServiceEnabled(@NotNull PsiElement element) {
        String typeFromService;
        PsiFile file2;
        FlowJSServerService service;
        if (element == null) {
            FlowJSServerService.$$$reportNull$$$0(10);
        }
        if ((element instanceof JSReferenceExpression || element instanceof JSNamedElement) && (service = FlowJSServerManager.getService(file2 = element.getContainingFile())) != null && FlowJSSettingsManager.areOtherServicesEnabled(file2) && (typeFromService = service.getTypeOfElement((JSElement)element)) != null) {
            return XmlUtil.escape((String)typeFromService);
        }
        return null;
    }

    @Override
    public boolean canHighlight(@NotNull PsiFile file2) {
        if (file2 == null) {
            FlowJSServerService.$$$reportNull$$$0(11);
        }
        return true;
    }

    @Override
    @NotNull
    public Condition<VirtualFile> getAcceptableFilesFilter() {
        Condition<VirtualFile> condition = FILES_TO_PROCESS;
        if (condition == null) {
            FlowJSServerService.$$$reportNull$$$0(12);
        }
        return condition;
    }

    @Override
    protected boolean needInitToolWindow() {
        FlowJSServerManager serverManager = FlowJSServerManager.getInstance(this.myProject);
        return serverManager != null && serverManager.isFlowAvailable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleId";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSServerService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSServerService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPossibleFlowExecutableFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowExecutableFilename";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptableFilesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementByPosition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfElementUnderProgress";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFlowServerAvailable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIfServiceEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canHighlight";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypeOfElementUnderProgress$3";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

