/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspection.JSSuspiciousInstanceofCheck;
import com.intellij.lang.javascript.inspection.JSSuspiciousNullOrUndefinedCheck;
import com.intellij.lang.javascript.inspection.JSSuspiciousTypeOfCheck;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JavaScriptTypeGuard;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuspiciousTypeGuardInspection
extends JSInspection {
    @Override
    @NotNull
    public String getShortName() {
        if ("SuspiciousTypeOfGuard" == null) {
            JSSuspiciousTypeGuardInspection.$$$reportNull$$$0(0);
        }
        return "SuspiciousTypeOfGuard";
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSSuspiciousTypeGuardInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSSuspiciousTypeGuardInspection.$$$reportNull$$$0(2);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression expression) {
                JSPrefixExpression rightTypeOf;
                IElementType sign = expression.getOperationSign();
                if (sign == JSTokenTypes.INSTANCEOF_KEYWORD) {
                    JSSuspiciousInstanceofCheck.checkInstanceOfGuard(holder, expression, JSSuspiciousTypeGuardInspection.this.getProblemHighlighter());
                    return;
                }
                if (!JSSuspiciousTypeGuardInspection.isEqualityLikeSign(sign)) {
                    return;
                }
                JSExpression left = JSTypeGuardChecker.getReferenceCandidate(expression.getLOperand());
                JSExpression right = JSTypeGuardChecker.getReferenceCandidate(expression.getROperand());
                if (left == null || right == null) {
                    return;
                }
                JSPrefixExpression leftTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(left);
                if (leftTypeOf != null && JSTypeGuardChecker.isStringLiteralExpression(right)) {
                    JSSuspiciousTypeOfCheck.checkTypeofGuard(holder, expression, leftTypeOf, (JSLiteralExpression)right, sign, JSSuspiciousTypeGuardInspection.this.getProblemHighlighter());
                }
                if ((rightTypeOf = JSTypeGuardChecker.getTypeOfPrefixExpression(right)) != null && JSTypeGuardChecker.isStringLiteralExpression(left)) {
                    JSSuspiciousTypeOfCheck.checkTypeofGuard(holder, expression, rightTypeOf, (JSLiteralExpression)left, sign, JSSuspiciousTypeGuardInspection.this.getProblemHighlighter());
                }
                if (JavaScriptTypeGuard.isUndefinedOrNullExpression(left)) {
                    JSSuspiciousNullOrUndefinedCheck.checkNullOrUndefinedGuard(holder, expression, sign, right, left, JSSuspiciousTypeGuardInspection.this.getProblemHighlighter());
                }
                if (JavaScriptTypeGuard.isUndefinedOrNullExpression(right)) {
                    JSSuspiciousNullOrUndefinedCheck.checkNullOrUndefinedGuard(holder, expression, sign, left, right, JSSuspiciousTypeGuardInspection.this.getProblemHighlighter());
                }
            }
        };
        if (jSElementVisitor == null) {
            JSSuspiciousTypeGuardInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    @NotNull
    protected ProblemHighlightType getProblemHighlighter() {
        ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        if (problemHighlightType == null) {
            JSSuspiciousTypeGuardInspection.$$$reportNull$$$0(4);
        }
        return problemHighlightType;
    }

    @Contract(value="null->false")
    private static boolean isEqualityLikeSign(@Nullable IElementType sign) {
        return sign == JSTokenTypes.EQEQ || sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.EQEQEQ;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspection/JSSuspiciousTypeGuardInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspection/JSSuspiciousTypeGuardInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

