/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterBaseView;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintView
extends JSLinterBaseView<UiState> {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final NodePackageField myEslintPackageField;
    private final JSLinterConfigFileView myConfigFileView;
    private final TextFieldWithBrowseButton myAdditionalRulesDirField;
    private final RawCommandLineEditor myExtraOptions;
    private final JPanel myCenterPanel;
    private final JPanel myConfigurationPanel;
    private final JLabel myPackageErrorLabel;

    public EslintView(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            EslintView.$$$reportNull$$$0(0);
        }
        super(fullModeDialog);
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        List packageNames = ContainerUtil.list((Object[])new String[]{"eslint", "standard"});
        this.myEslintPackageField = new NodePackageField(project, packageNames, () -> this.myNodeInterpreterField.getInterpreter());
        this.myConfigFileView = new JSLinterConfigFileView(project, new JSLinterConfigFileTexts(JSBundle.message((String)"javascript.linter.configurable.config.autoSearch.title", (Object[])new Object[0]), JSBundle.message((String)"eslint.configurable.config.autoSearch.description.bodyInnerHtml", (Object[])new Object[0]), JSBundle.message((String)"eslint.configurable.config.select.config.text", (Object[])new Object[0]), "In each case, the settings in the configuration file override default settings."), null);
        this.myConfigFileView.setAdditionalConfigFilesProducer((NotNullProducer<List<VirtualFile>>)((NotNullProducer)() -> {
            if (project == null) {
                EslintView.$$$reportNull$$$0(16);
            }
            return EslintUtil.findAllConfigsInScope(project);
        }));
        this.myAdditionalRulesDirField = EslintView.createAdditionalRulesDirField(project);
        this.myExtraOptions = new RawCommandLineEditor();
        this.myExtraOptions.setDialogCaption("Extra ESLint Options");
        this.myConfigurationPanel = FormBuilder.createFormBuilder().addComponent((JComponent)this.myConfigFileView.getComponent()).addSeparator(4).addVerticalGap(4).addComponent(EslintView.createBottomComponent(this.myAdditionalRulesDirField, this.myExtraOptions)).getPanel();
        this.myPackageErrorLabel = new JLabel("");
        this.myPackageErrorLabel.setFont(UIUtil.getTitledBorderFont());
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).setVerticalGap(4).setFormLeftIndent(10).addLabeledComponent("&Node interpreter:", (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(JSBundle.message((String)"eslint.configurable.eslintPackage.label", (Object[])new Object[0]), (JComponent)((Object)this.myEslintPackageField)).addComponentToRightColumn((JComponent)this.myPackageErrorLabel).addComponentToRightColumn(EslintView.createStandardJSLabel()).addComponent((JComponent)this.myConfigurationPanel).getPanel();
        this.myEslintPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)nodePackage -> {
            this.myPackageErrorLabel.setText(JSLinterUtil.getRedErrorTextHtml(EslintView.formatErrorMessage(nodePackage)));
            this.myConfigurationPanel.setVisible(!EslintView.isStandardJs(nodePackage));
        }));
        this.myCenterPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel);
        this.myCenterPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    @NotNull
    private static JComponent createStandardJSLabel() {
        JLabel label = new JLabel();
        label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        Color foreground = UIUtil.getLabelDisabledForeground();
        label.setForeground(foreground);
        label.setText(JSBundle.message((String)"standardjs.eslint.label", (Object[])new Object[0]));
        JLabel jLabel = label;
        if (jLabel == null) {
            EslintView.$$$reportNull$$$0(1);
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createBottomComponent(@NotNull TextFieldWithBrowseButton field, @NotNull RawCommandLineEditor extraOptions) {
        if (field == null) {
            EslintView.$$$reportNull$$$0(2);
        }
        if (extraOptions == null) {
            EslintView.$$$reportNull$$$0(3);
        }
        JPanel jPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).setHorizontalGap(10).addLabeledComponent(JSBundle.message((String)"eslint.configurable.additionalRulesDir.label", (Object[])new Object[0]), (JComponent)field).addLabeledComponent(JSBundle.message((String)"eslint.configurable.extraOptions.label", (Object[])new Object[0]), (JComponent)extraOptions).getPanel();
        if (jPanel == null) {
            EslintView.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    private static TextFieldWithBrowseButton createAdditionalRulesDirField(@NotNull Project project) {
        if (project == null) {
            EslintView.$$$reportNull$$$0(5);
        }
        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)field, (String)JSBundle.message((String)"eslint.configurable.additionalRulesDir.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton = field;
        if (textFieldWithBrowseButton == null) {
            EslintView.$$$reportNull$$$0(6);
        }
        return textFieldWithBrowseButton;
    }

    @Override
    @Nullable
    protected Component createTopRightComponent() {
        return null;
    }

    @Override
    @NotNull
    protected Component createCenterComponent() {
        JPanel jPanel = this.myCenterPanel;
        if (jPanel == null) {
            EslintView.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    @Override
    protected void handleEnableStatusChanged(boolean enabled) {
        this.myConfigFileView.onEnabledStateChanged(enabled);
    }

    @Override
    @NotNull
    protected UiState getState() {
        UiState uiState = new UiState(this.getEslintState(), EslintView.isStandardJs(this.myEslintPackageField.getSelected()));
        if (uiState == null) {
            EslintView.$$$reportNull$$$0(8);
        }
        return uiState;
    }

    @Override
    protected void setState(@NotNull UiState state) {
        if (state == null) {
            EslintView.$$$reportNull$$$0(9);
        }
        this.setEslintState(state.myState);
        this.myConfigurationPanel.setVisible(!state.isStandardJS);
    }

    private EslintState getEslintState() {
        NodePackage selected = this.myEslintPackageField.getSelected();
        EslintState.Builder builder = new EslintState.Builder();
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setEslintPackagePath(selected.getSystemDependentPath());
        builder.setCustomConfigFilePath(this.myConfigFileView.getCustomConfigFilePath());
        builder.setCustomConfigFileUsed(this.myConfigFileView.isCustomConfigFileUsed());
        builder.setAdditionalRulesDirPath(this.myAdditionalRulesDirField.getText());
        builder.setExtraOptions(this.myExtraOptions.getText());
        return builder.build();
    }

    private void setEslintState(@NotNull EslintState state) {
        if (state == null) {
            EslintView.$$$reportNull$$$0(10);
        }
        this.myConfigurationPanel.setEnabled(true);
        this.myNodeInterpreterField.setInterpreterRef(state.getInterpreterRef());
        this.myEslintPackageField.setSelected(new NodePackage(state.getEslintPackagePath()));
        this.myConfigFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.myConfigFileView.setCustomConfigFilePath(state.getCustomConfigFilePath());
        this.myAdditionalRulesDirField.setText(state.getAdditionalRulesDirPath());
        this.myExtraOptions.setText(state.getExtraOptions());
        if (this.isFullModeDialog()) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myConfigFileView.setPreferredWidthToComponents();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)this.myAdditionalRulesDirField);
        }
    }

    @NotNull
    private static String formatErrorMessage(@NotNull NodePackage pkg) {
        if (pkg == null) {
            EslintView.$$$reportNull$$$0(11);
        }
        if (pkg.getSystemDependentPath().trim().isEmpty()) {
            if ("Empty path" == null) {
                EslintView.$$$reportNull$$$0(12);
            }
            return "Empty path";
        }
        if (!pkg.isValid()) {
            if ("Package directory expected" == null) {
                EslintView.$$$reportNull$$$0(13);
            }
            return "Package directory expected";
        }
        if ("" == null) {
            EslintView.$$$reportNull$$$0(14);
        }
        return "";
    }

    private static boolean isStandardJs(@NotNull NodePackage nodePackage) {
        if (nodePackage == null) {
            EslintView.$$$reportNull$$$0(15);
        }
        String packageName = nodePackage.getName();
        return "standard".equals(packageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraOptions";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStandardJSLabel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createBottomComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalRulesDirField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createBottomComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalRulesDirField";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setEslintState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isStandardJs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UiState
    implements JSLinterState {
        private final EslintState myState;
        private final boolean isStandardJS;

        public UiState(@NotNull EslintState eslintState, boolean isStandardJs) {
            if (eslintState == null) {
                UiState.$$$reportNull$$$0(0);
            }
            this.myState = eslintState;
            this.isStandardJS = isStandardJs;
        }

        @NotNull
        public EslintState getState() {
            EslintState eslintState = this.myState;
            if (eslintState == null) {
                UiState.$$$reportNull$$$0(1);
            }
            return eslintState;
        }

        public boolean isStandardJS() {
            return this.isStandardJS;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UiState state = (UiState)o;
            if (this.isStandardJS != state.isStandardJS) {
                return false;
            }
            return this.myState.equals(state.myState);
        }

        public int hashCode() {
            int result2 = this.myState.hashCode();
            result2 = 31 * result2 + (this.isStandardJS ? 1 : 0);
            return result2;
        }

        public String toString() {
            return "UiState{myState=" + this.myState + ", isStandardJS=" + this.isStandardJS + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "eslintState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintView$UiState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintView$UiState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

