/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;

public class JSMethodNavigationOffsetProvider
implements MethodNavigationOffsetProvider {
    public int[] getMethodNavigationOffsets(PsiFile file2, int caretOffset) {
        PsiElement elementAtCaret;
        JSEmbeddedContent embeddedContent;
        PsiFile rootElement = null;
        if (file2 instanceof JSFile) {
            rootElement = file2;
        } else if (file2 instanceof XmlFile && (embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)(elementAtCaret = file2.findElementAt(caretOffset)), JSEmbeddedContent.class)) != null) {
            rootElement = embeddedContent;
        }
        if (rootElement == null) {
            return null;
        }
        final ArrayList array = new ArrayList();
        rootElement.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSClass(JSClass aClass) {
                array.add(aClass);
                ASTNode rBrace = aClass.getNode().findChildByType(JSTokenTypes.RBRACE);
                if (rBrace != null) {
                    array.add(rBrace.getPsi());
                }
                super.visitJSClass(aClass);
            }

            public boolean visitAsFunction(JSFunction function) {
                PsiElement parent;
                if (function instanceof JSFunctionExpression && ((parent = function.getParent()) instanceof JSArgumentList || parent instanceof JSExpression && !(parent instanceof JSAssignmentExpression))) {
                    return true;
                }
                array.add(function);
                return true;
            }
        });
        return MethodUpDownUtil.offsetsFromElements(array);
    }
}

