/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

class FlowJSConfigurationPanel {
    private final JPanel myPanel;
    private final TextFieldWithHistoryWithBrowseButton myFlowExecutable;
    private final JCheckBox myTypeChecking;
    private final JCheckBox myOtherServices;
    private final JCheckBox myAutosaveCheckBox;
    private final Project myProject;
    private final NotNullLazyValue<FlowJSExecutables> myFlowExecutables;

    FlowJSConfigurationPanel(@NotNull Project project) {
        if (project == null) {
            FlowJSConfigurationPanel.$$$reportNull$$$0(0);
        }
        this.myFlowExecutables = new NotNullLazyValue<FlowJSExecutables>(){

            @NotNull
            protected FlowJSExecutables compute() {
                FlowJSExecutables flowJSExecutables = new FlowJSExecutables(FlowJSServerService.calcPossibleFlowExecutableFiles(FlowJSConfigurationPanel.this.myProject));
                if (flowJSExecutables == null) {
                    1.$$$reportNull$$$0(0);
                }
                return flowJSExecutables;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel$1", "compute"));
            }
        };
        this.myProject = project;
        this.myFlowExecutable = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"js.flow.settings.executable.dialog.title", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor(), () -> ((FlowJSExecutables)this.myFlowExecutables.getValue()).getPaths());
        ((TextFieldWithHistory)this.myFlowExecutable.getChildComponent()).addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FlowJSConfigurationPanel.this.updateEnabled();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel$2", "textChanged"));
            }
        });
        this.myTypeChecking = new JBCheckBox(JSBundle.message((String)"js.flow.enable.type.checking", (Object[])new Object[0]), FlowJSSettings.DEFAULT.isTypeCheckingEnabled());
        this.myTypeChecking.addChangeListener(e -> this.updateEnabled());
        this.myOtherServices = new JBCheckBox(JSBundle.message((String)"js.flow.enable.other.services", (Object[])new Object[0]), FlowJSSettings.DEFAULT.isOtherServicesEnabled());
        this.myAutosaveCheckBox = new JBCheckBox(JSBundle.message((String)"js.flow.settings.auto.save", (Object[])new Object[0]), FlowJSSettings.DEFAULT.isAutoSaveEnabled());
        ComponentPanelBuilder builder = new ComponentPanelBuilder((JComponent)this.myAutosaveCheckBox).withComment(JSBundle.message((String)"js.flow.settings.auto.save.warning", (Object[])new Object[0]));
        this.myPanel = FormBuilder.createFormBuilder().setVerticalGap(8).addSeparator().addLabeledComponent(JSBundle.message((String)"js.flow.settings.executable.label", (Object[])new Object[0]), (JComponent)this.myFlowExecutable).addComponent((JComponent)new JBLabel(JSBundle.message((String)"js.flow.services.label", (Object[])new Object[0]))).addComponent((JComponent)this.myTypeChecking).addComponent((JComponent)this.myOtherServices).addSeparator().addComponent((JComponent)builder.createPanel()).getPanel();
        this.myPanel.setVisible(false);
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    public FlowJSSettings getFlowSettings() {
        return new FlowJSSettings.Builder().setFlowExecutablePath(this.myFlowExecutable.getText()).setTypeCheckingEnabled(this.myTypeChecking.isSelected()).setOtherServicesEnabled(this.myOtherServices.isSelected()).setAutoSaveEnabled(this.myAutosaveCheckBox.isSelected()).build();
    }

    public void setFlowSettings(@NotNull FlowJSSettings settings) {
        if (settings == null) {
            FlowJSConfigurationPanel.$$$reportNull$$$0(1);
        }
        String path = settings.getFlowExecutablePath();
        this.myFlowExecutable.setTextAndAddToHistory(FileUtil.toSystemIndependentName((String)path));
        if (!path.isEmpty()) {
            this.myTypeChecking.setSelected(settings.isTypeCheckingEnabled());
            this.myOtherServices.setSelected(settings.isOtherServicesEnabled());
            this.myAutosaveCheckBox.setSelected(settings.isAutoSaveEnabled());
        }
        this.myPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                List<String> executables;
                if (StringUtil.isEmpty((String)FlowJSConfigurationPanel.this.myFlowExecutable.getText()) && !(executables = ((FlowJSExecutables)FlowJSConfigurationPanel.this.myFlowExecutables.getValue()).getPaths()).isEmpty()) {
                    FlowJSConfigurationPanel.this.myFlowExecutable.setText(executables.get(0));
                    FlowJSConfigurationPanel.this.myTypeChecking.setSelected(false);
                }
            }
        });
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean pathIsEmpty = this.myFlowExecutable.getText().isEmpty();
        boolean typeCheckSelected = this.myTypeChecking.isSelected();
        this.myTypeChecking.setEnabled(!pathIsEmpty);
        this.myOtherServices.setEnabled(!pathIsEmpty && typeCheckSelected);
        this.myAutosaveCheckBox.setEnabled(!pathIsEmpty && typeCheckSelected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setFlowSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FlowJSExecutables {
        @NotNull
        private final List<? extends FlowJSSettings.FlowJSExecutable> myExecutables;

        FlowJSExecutables(@NotNull List<? extends FlowJSSettings.FlowJSExecutable> executables) {
            if (executables == null) {
                FlowJSExecutables.$$$reportNull$$$0(0);
            }
            this.myExecutables = executables;
        }

        public List<String> getPaths() {
            return this.myExecutables.stream().map(FlowJSSettings.FlowJSExecutable::getPackageOrExePath).collect(Collectors.toList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executables", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel$FlowJSExecutables", "<init>"));
        }
    }
}

