/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.inspections;

import b.h.la;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.IncorrectOperationException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyVersionCallTypeProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.inspections.a;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.support.UIUtil;

public class RubyVersionInspection
extends RubyInspection {
    @NonNls
    private static final String b = "RubyVersionInspection";
    private String a = null;
    private static final long c = la.a(-6832753588917777648L, 9007139874342198874L, MethodHandles.lookup().lookupClass()).a(175059191396265L);

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        long l2 = c ^ 0x67ADDC726B38L;
        String string = RBundle.message((String)"gems.gems");
        if (string == null) {
            RubyVersionInspection.b(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = c ^ 0x32BA85BF9510L;
        String string = RBundle.message((String)"gems.inspection.wrong.ruby.version.description");
        if (string == null) {
            RubyVersionInspection.b(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        long l2 = c ^ 0x2850D7B86F36L;
        if (b == null) {
            RubyVersionInspection.b(2);
        }
        return b;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyVersionInspection.b(3);
        }
        RubyVersionVisitor rubyVersionVisitor = new RubyVersionVisitor(holder);
        if (rubyVersionVisitor == null) {
            RubyVersionInspection.b(4);
        }
        return rubyVersionVisitor;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    private static String a(Sdk sdk) {
        long l2 = c ^ 0x6C15734E571L;
        String string = sdk.getVersionString();
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("^(\\w+\\.)([\\d\\.]+)(\\s)?.*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x187A852C5873L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RubySdkQuickFix
    extends RubyFix {
        private static final long a = la.a(-1526132998748737717L, 8138986644961460013L, MethodHandles.lookup().lookupClass()).a(226177043077137L);

        private RubySdkQuickFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            long l2 = a ^ 0x1B9A91692F98L;
            if (project == null) {
                RubySdkQuickFix.b(0);
            }
            if (descriptor == null) {
                RubySdkQuickFix.b(1);
            }
            Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
            ArrayList<Sdk> arrayList = new ArrayList<Sdk>();
            for (Sdk sdk : sdkArray) {
                String string;
                if (!(sdk.getSdkType() instanceof RubySdkType) || (string = RubyVersionInspection.a(sdk)) == null || RubyVersionInspection.this.a == null || !string.equals(RubyVersionInspection.this.a)) continue;
                arrayList.add(sdk);
            }
            if (arrayList.isEmpty()) {
                Notifications.Bus.notify((Notification)new NoSdkMatchNotification("NoSdkNotificationId", RBundle.message((String)"gem.inspection.notification.no.matching.sdk", (Object[])new Object[]{RubyVersionInspection.this.a}), RBundle.message((String)"gem.inspection.notification.no.matching.sdk.body"), NotificationType.WARNING));
            } else {
                SwingUtilities.invokeLater(() -> {
                    if (project == null) {
                        RubySdkQuickFix.b(4);
                    }
                    UIUtil.openRubyProjectSettings(project);
                });
            }
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            long l2 = a ^ 0x42576FDEA680L;
            String string = RBundle.message((String)"gems.inspection.ruby.version.fix.family.name");
            if (string == null) {
                RubySdkQuickFix.b(2);
            }
            return string;
        }

        @NotNull
        public String getName() {
            long l2 = a ^ 0x61CD2BA03A54L;
            String string = RBundle.message((String)"gems.inspection.ruby.version.fix", (Object[])new Object[]{RubyVersionInspection.this.a});
            if (string == null) {
                RubySdkQuickFix.b(3);
            }
            return string;
        }

        /* synthetic */ RubySdkQuickFix(a x1) {
            this();
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x7579AEB8554L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection$RubySdkQuickFix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection$RubySdkQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$doFix$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class NoSdkMatchNotification
        extends Notification {
            private static final long a = la.a(3306573904683246780L, 7875252737722721667L, MethodHandles.lookup().lookupClass()).a(125391190151842L);

            NoSdkMatchNotification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, NotificationType type) {
                if (groupDisplayId == null) {
                    NoSdkMatchNotification.a(0);
                }
                if (title == null) {
                    NoSdkMatchNotification.a(1);
                }
                if (content == null) {
                    NoSdkMatchNotification.a(2);
                }
                if (type == null) {
                    NoSdkMatchNotification.a(3);
                }
                super(groupDisplayId, title, content, type);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x5A8F534184A0L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "groupDisplayId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "content";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection$RubySdkQuickFix$NoSdkMatchNotification";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class RubyVersionVisitor
    extends RubyInspectionVisitor {
        private static final long b = la.a(6460347827347553081L, 8790055805389849690L, MethodHandles.lookup().lookupClass()).a(179396953342621L);

        RubyVersionVisitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        public void visitRCall(RCall rCall) {
            long l2 = b ^ 0x7ED1039C6230L;
            PsiFile psiFile = rCall.getContainingFile();
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            if (!BundlerUtil.isGemfile((PsiFileSystemItem)psiFile)) {
                return;
            }
            if (!(rCall.getCallType() instanceof RubyVersionCallTypeProvider.RubyVersionCallType)) {
                return;
            }
            List list2 = (List)rCall.getData(new RubyCallType[0]);
            RubyVersionInspection.this.a = (String)list2.get(0);
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)rCall.getProject());
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk != null) {
                String string;
                if (sdk.getSdkType() instanceof RubySdkType && (string = RubyVersionInspection.a(sdk)) != null && !string.equals(RubyVersionInspection.this.a)) {
                    this.a((PsiElement)rCall, string, RubyVersionInspection.this.a);
                }
            } else {
                this.registerProblem((PsiElement)rCall, RBundle.message((String)"gems.inspection.no.ruby.version.set", (Object[])new Object[]{RubyVersionInspection.this.a}));
            }
        }

        private void a(PsiElement psiElement, String string, String string2) {
            long l2 = b ^ 0x146C073C64D0L;
            this.registerProblem(psiElement, RBundle.message((String)"gems.inspection.wrong.ruby.version", (Object[])new Object[]{string, string2}), new RubySdkQuickFix(null));
        }
    }
}

