/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.javafx;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.NettyKt;
import java.awt.Component;
import java.awt.Point;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.swing.JFrame;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.references.MarkdownAnchorReference;
import org.intellij.plugins.markdown.ui.preview.MarkdownSplitEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SafeOpener {
    private static final Logger LOG = Logger.getInstance(SafeOpener.class);
    private static final Set<String> SCHEMES = ContainerUtil.newTroveSet((Object[])new String[]{"http", "https"});
    private static final Set<String> SAFE_LOCAL_EXTENSIONS = ContainerUtil.newTroveSet((Object[])new String[]{"md", "png", "gif", "jpg", "jpeg", "bmp", "svg", "html"});

    private SafeOpener() {
    }

    static void openLink(@NotNull String link) {
        URI uri;
        if (link == null) {
            SafeOpener.$$$reportNull$$$0(0);
        }
        try {
            uri = !BrowserUtil.isAbsoluteURL((String)link) ? new URI("http://" + link) : new URI(link);
        }
        catch (URISyntaxException e) {
            LOG.info((Throwable)e);
            return;
        }
        if (SafeOpener.tryOpenInEditor(uri)) {
            return;
        }
        if (!SafeOpener.isHttpScheme(uri.getScheme()) || SafeOpener.isLocalHost(uri.getHost()) && !SafeOpener.isSafeExtension(uri.getPath())) {
            LOG.warn("Bad URL", (Throwable)new InaccessibleURLOpenedException(link));
            return;
        }
        BrowserUtil.browse((URI)uri);
    }

    private static boolean tryOpenInEditor(@NotNull URI uri) {
        if (uri == null) {
            SafeOpener.$$$reportNull$$$0(1);
        }
        if (!"file".equals(uri.getScheme())) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (uri == null) {
                SafeOpener.$$$reportNull$$$0(9);
            }
            String anchor = uri.getFragment();
            String path = uri.getPath();
            VirtualFile targetFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (targetFile == null) {
                return false;
            }
            Project project = ProjectUtil.guessProjectForContentFile((VirtualFile)targetFile);
            if (project == null) {
                return false;
            }
            if (anchor == null) {
                ApplicationManager.getApplication().invokeLater(() -> OpenFileAction.openFile((VirtualFile)targetFile, (Project)project));
                return true;
            }
            JFrame frame = WindowManager.getInstance().getFrame(project);
            Point mousePosition = Objects.requireNonNull(frame).getMousePosition();
            if (mousePosition == null) {
                return false;
            }
            RelativePoint point = new RelativePoint((Component)frame, mousePosition);
            ApplicationManager.getApplication().invokeLater(() -> {
                Collection headers = (Collection)ReadAction.compute(() -> MarkdownAnchorReference.Companion.getPsiHeaders(project, anchor, PsiManager.getInstance((Project)project).findFile(targetFile)));
                if (headers.isEmpty()) {
                    SafeOpener.showCannotNavigateNotification(project, anchor, point);
                } else if (headers.size() == 1) {
                    SafeOpener.navigateToHeader(targetFile, (PsiElement)Objects.requireNonNull(ContainerUtil.getFirstItem((Collection)headers)));
                } else {
                    SafeOpener.showHeadersPopup(headers, point);
                }
            });
            return true;
        });
    }

    private static void showCannotNavigateNotification(@NotNull Project project, @NotNull String anchor, @NotNull RelativePoint point) {
        if (project == null) {
            SafeOpener.$$$reportNull$$$0(2);
        }
        if (anchor == null) {
            SafeOpener.$$$reportNull$$$0(3);
        }
        if (point == null) {
            SafeOpener.$$$reportNull$$$0(4);
        }
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(MarkdownBundle.message("markdown.navigate.to.header.no.headers", anchor), MessageType.WARNING, null);
        Balloon balloon = balloonBuilder.createBalloon();
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)project, (Disposable)balloon);
    }

    private static void navigateToHeader(@NotNull VirtualFile targetFile, @NotNull PsiElement item) {
        FileEditor editor;
        if (targetFile == null) {
            SafeOpener.$$$reportNull$$$0(5);
        }
        if (item == null) {
            SafeOpener.$$$reportNull$$$0(6);
        }
        if ((editor = FileEditorManager.getInstance((Project)item.getProject()).getSelectedEditor(targetFile)) == null) {
            return;
        }
        MarkdownSplitEditor splitEditor = (MarkdownSplitEditor)editor;
        boolean oldAutoScrollPreview = splitEditor.isAutoScrollPreview();
        if (!oldAutoScrollPreview) {
            splitEditor.setAutoScrollPreview(true);
        }
        PsiNavigateUtil.navigate((PsiElement)item);
        if (!oldAutoScrollPreview) {
            splitEditor.setAutoScrollPreview(false);
        }
    }

    private static void showHeadersPopup(@NotNull Collection<PsiElement> headers, @NotNull RelativePoint point) {
        if (headers == null) {
            SafeOpener.$$$reportNull$$$0(7);
        }
        if (point == null) {
            SafeOpener.$$$reportNull$$$0(8);
        }
        BaseListPopupStep<PsiElement> headersPopup = new BaseListPopupStep<PsiElement>(MarkdownBundle.message("markdown.navigate.to.header", new Object[0]), (List)ContainerUtil.newArrayList(headers)){

            @NotNull
            public String getTextFor(PsiElement value) {
                Document document = FileDocumentManager.getInstance().getDocument(value.getContainingFile().getVirtualFile());
                String name = value.getContainingFile().getVirtualFile().getName();
                String string = value.getText() + " (" + name + ":" + (Objects.requireNonNull(document).getLineNumber(value.getTextOffset()) + 1) + ")";
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public PopupStep onChosen(PsiElement selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> SafeOpener.navigateToHeader(selectedValue.getContainingFile().getVirtualFile(), selectedValue));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/javafx/SafeOpener$1", "getTextFor"));
            }
        };
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)headersPopup).show(point);
    }

    private static boolean isHttpScheme(@Nullable String scheme) {
        return scheme != null && SCHEMES.contains(scheme.toLowerCase(Locale.US));
    }

    private static boolean isLocalHost(@Nullable String hostName) {
        return hostName == null || hostName.startsWith("127.") || hostName.endsWith(":1") || NettyKt.isLocalHost((String)hostName, (boolean)false, (boolean)false);
    }

    private static boolean isSafeExtension(@Nullable String path) {
        if (path == null) {
            return false;
        }
        int i = path.lastIndexOf(46);
        return i != -1 && SAFE_LOCAL_EXTENSIONS.contains(path.substring(i + 1).toLowerCase(Locale.US));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headers";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/javafx/SafeOpener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openLink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "tryOpenInEditor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showCannotNavigateNotification";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateToHeader";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showHeadersPopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$tryOpenInEditor$3";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InaccessibleURLOpenedException
    extends IllegalArgumentException {
        InaccessibleURLOpenedException(String link) {
            super(link);
        }
    }
}

