/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.actions.BrowseShelfAction;
import org.jetbrains.idea.perforce.actions.RevertAllUnchangedFilesAction;
import org.jetbrains.idea.perforce.application.PerforceCheckinOptionsPanel;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.ShelvedChange;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class PerforceCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    public PerforceCheckinHandlerFactory() {
        super(PerforceVcs.getKey());
    }

    @NotNull
    protected CheckinHandler createVcsHandler(final CheckinProjectPanel panel) {
        CheckinHandler checkinHandler = new CheckinHandler(){

            @Nullable
            public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
                return new PerforceCheckinOptionsPanel(panel.getProject());
            }

            public CheckinHandler.ReturnResult beforeCheckin() {
                Project project = panel.getProject();
                if (PerforceSettings.getSettings((Project)project).REVERT_UNCHANGED_FILES_CHECKIN) {
                    RevertAllUnchangedFilesAction.revertUnchanged(project, panel.getVirtualFiles(), panel, null);
                }
                MultiMap map = MultiMap.create();
                for (Change change : panel.getSelectedChanges()) {
                    LocalChangeList list = ChangeListManager.getInstance((Project)project).getChangeList(change);
                    if (list == null) continue;
                    map.putValue((Object)list, (Object)change);
                }
                for (LocalChangeList list : map.keySet()) {
                    List<ShelvedChange> shelvedChanges = PerforceManager.getInstance(project).getShelf().getShelvedChanges(list);
                    if (shelvedChanges.isEmpty()) continue;
                    String message = "The changelist \"" + list.getName() + "\" has shelved changes in Perforce.";
                    int rc = Messages.showYesNoDialog((Project)project, (String)message, (String)"Shelved Changes Found", (String)"&Remove Shelved Changes", (String)"Cancel", (Icon)Messages.getQuestionIcon());
                    if (rc == 1) {
                        return CheckinHandler.ReturnResult.CANCEL;
                    }
                    BrowseShelfAction.deleteFromShelf(shelvedChanges, project);
                }
                return super.beforeCheckin();
            }
        };
        if (checkinHandler == null) {
            PerforceCheckinHandlerFactory.$$$reportNull$$$0(0);
        }
        return checkinHandler;
    }

    public BeforeCheckinDialogHandler createSystemReadyHandler(@NotNull Project project) {
        if (project == null) {
            PerforceCheckinHandlerFactory.$$$reportNull$$$0(1);
        }
        return new MyBeforeCheckinDialogHandler();
    }

    public static boolean beforeRemoteOperationCheck(Project project, String operationName) {
        int result;
        PerforceSettings settings = PerforceSettings.getSettings(project);
        if (!settings.ENABLED && 0 == (result = Messages.showYesNoDialog((Project)project, (String)("Perforce is offline. " + operationName + " is not possible in this state.\nGo online?"), (String)"Perforce Is Offline", (Icon)Messages.getWarningIcon()))) {
            settings.enable();
        }
        boolean allOk = PerforceLoginManager.getInstance(project).checkAndRepairAll();
        return ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length > 1 || allOk && settings.ENABLED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVcsHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSystemReadyHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBeforeCheckinDialogHandler
    extends BeforeCheckinDialogHandler {
        private MyBeforeCheckinDialogHandler() {
        }

        public boolean beforeCommitDialogShown(@NotNull Project project, @NotNull List<Change> changes, @NotNull Iterable<CommitExecutor> executors, boolean showVcsCommit) {
            if (project == null) {
                MyBeforeCheckinDialogHandler.$$$reportNull$$$0(0);
            }
            if (changes == null) {
                MyBeforeCheckinDialogHandler.$$$reportNull$$$0(1);
            }
            if (executors == null) {
                MyBeforeCheckinDialogHandler.$$$reportNull$$$0(2);
            }
            if (showVcsCommit) {
                return PerforceCheckinHandlerFactory.beforeRemoteOperationCheck(project, "Commit");
            }
            for (CommitExecutor executor : executors) {
                if (executor instanceof LocalCommitExecutor) continue;
                return PerforceCheckinHandlerFactory.beforeRemoteOperationCheck(project, "Commit");
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executors";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory$MyBeforeCheckinDialogHandler";
            objectArray[2] = "beforeCommitDialogShown";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

