/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.requests.GithubGistRequest;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.ui.GithubCreateGistDialog;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubCreateGistAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String FAILED_TO_CREATE_GIST = "Can't create Gist";

    protected GithubCreateGistAction() {
        super("Create Gist...", "Create GitHub Gist", AllIcons.Vcs.Vendors.Github);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GithubCreateGistAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null || editor != null && editor.getDocument().getTextLength() == 0) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GithubCreateGistAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project.isDefault()) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (editor == null && file == null && files == null) {
            return;
        }
        GithubCreateGistAction.createGistAction(project, editor, file, files);
    }

    private static void createGistAction(final @NotNull Project project, final @Nullable Editor editor, final @Nullable VirtualFile file, final @Nullable VirtualFile[] files) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(2);
        }
        if (!GithubAccountsMigrationHelper.getInstance().migrate(project)) {
            return;
        }
        GithubAuthenticationManager authManager = GithubAuthenticationManager.getInstance();
        if (!authManager.ensureHasAccounts(project)) {
            return;
        }
        GithubSettings settings = GithubSettings.getInstance();
        final GithubCreateGistDialog dialog2 = new GithubCreateGistDialog(project, authManager.getAccounts(), authManager.getDefaultAccount(project), GithubCreateGistAction.getFileName(editor, files), settings.isPrivateGist(), settings.isOpenInBrowserGist(), settings.isCopyURLGist());
        if (!dialog2.showAndGet()) {
            return;
        }
        settings.setPrivateGist(dialog2.isSecret());
        settings.setOpenInBrowserGist(dialog2.isOpenInBrowser());
        settings.setCopyURLGist(dialog2.isCopyURL());
        final GithubApiRequestExecutor.WithTokenAuth requestExecutor = GithubApiRequestExecutorManager.getInstance().getExecutor(dialog2.getAccount(), project);
        if (requestExecutor == null) {
            return;
        }
        final GithubServerPath server = dialog2.getAccount().getServer();
        final Ref url = new Ref();
        new Task.Backgroundable(project, "Creating Gist..."){

            public void run(@NotNull ProgressIndicator indicator) {
                List<GithubGistRequest.FileContent> contents;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((contents = GithubCreateGistAction.collectContents(project, editor, file, files)).isEmpty()) {
                    return;
                }
                String gistUrl = GithubCreateGistAction.createGist(project, requestExecutor, indicator, server, contents, dialog2.isSecret(), dialog2.getDescription(), dialog2.getFileName());
                url.set((Object)gistUrl);
            }

            public void onSuccess() {
                if (url.isNull()) {
                    return;
                }
                if (dialog2.isCopyURL()) {
                    StringSelection stringSelection = new StringSelection((String)url.get());
                    CopyPasteManager.getInstance().setContents((Transferable)stringSelection);
                }
                if (dialog2.isOpenInBrowser()) {
                    BrowserUtil.browse((String)((String)url.get()));
                } else {
                    GithubNotifications.showInfoURL(project, "Gist Created Successfully", "Your gist url", (String)url.get());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/github/GithubCreateGistAction$1", "run"));
            }
        }.queue();
    }

    @Nullable
    private static String getFileName(@Nullable Editor editor, @Nullable VirtualFile[] files) {
        if (files != null && files.length == 1 && !files[0].isDirectory()) {
            return files[0].getName();
        }
        if (editor != null) {
            return "";
        }
        return null;
    }

    @NotNull
    static List<GithubGistRequest.FileContent> collectContents(@NotNull Project project, @Nullable Editor editor, @Nullable VirtualFile file, @Nullable VirtualFile[] files) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(3);
        }
        if (editor != null) {
            String content = GithubCreateGistAction.getContentFromEditor(editor);
            if (content == null) {
                List<GithubGistRequest.FileContent> list2 = Collections.emptyList();
                if (list2 == null) {
                    GithubCreateGistAction.$$$reportNull$$$0(4);
                }
                return list2;
            }
            if (file != null) {
                List<GithubGistRequest.FileContent> list3 = Collections.singletonList(new GithubGistRequest.FileContent(file.getName(), content));
                if (list3 == null) {
                    GithubCreateGistAction.$$$reportNull$$$0(5);
                }
                return list3;
            }
            List<GithubGistRequest.FileContent> list4 = Collections.singletonList(new GithubGistRequest.FileContent("", content));
            if (list4 == null) {
                GithubCreateGistAction.$$$reportNull$$$0(6);
            }
            return list4;
        }
        if (files != null) {
            ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
            for (VirtualFile vf : files) {
                contents.addAll(GithubCreateGistAction.getContentFromFile(vf, project, null));
            }
            ArrayList<GithubGistRequest.FileContent> arrayList = contents;
            if (arrayList == null) {
                GithubCreateGistAction.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        if (file != null) {
            List<GithubGistRequest.FileContent> list5 = GithubCreateGistAction.getContentFromFile(file, project, null);
            if (list5 == null) {
                GithubCreateGistAction.$$$reportNull$$$0(8);
            }
            return list5;
        }
        LOG.error("File, files and editor can't be null all at once!");
        throw new IllegalStateException("File, files and editor can't be null all at once!");
    }

    @Nullable
    static String createGist(@NotNull Project project, @NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator, @NotNull GithubServerPath server, @NotNull List<? extends GithubGistRequest.FileContent> contents, boolean isSecret, @NotNull String description, @Nullable String filename) {
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(9);
        }
        if (executor == null) {
            GithubCreateGistAction.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            GithubCreateGistAction.$$$reportNull$$$0(11);
        }
        if (server == null) {
            GithubCreateGistAction.$$$reportNull$$$0(12);
        }
        if (contents == null) {
            GithubCreateGistAction.$$$reportNull$$$0(13);
        }
        if (description == null) {
            GithubCreateGistAction.$$$reportNull$$$0(14);
        }
        if (contents.isEmpty()) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Can't create empty gist");
            return null;
        }
        if (contents.size() == 1 && filename != null) {
            GithubGistRequest.FileContent entry = contents.iterator().next();
            contents = Collections.singletonList(new GithubGistRequest.FileContent(filename, entry.getContent()));
        }
        try {
            return executor.execute(indicator, GithubApiRequests.Gists.create(server, contents, description, !isSecret)).getHtmlUrl();
        }
        catch (IOException e) {
            GithubNotifications.showError(project, FAILED_TO_CREATE_GIST, e);
            return null;
        }
    }

    @Nullable
    private static String getContentFromEditor(@NotNull Editor editor) {
        String text;
        if (editor == null) {
            GithubCreateGistAction.$$$reportNull$$$0(15);
        }
        if ((text = (String)ReadAction.compute(() -> {
            if (editor == null) {
                GithubCreateGistAction.$$$reportNull$$$0(30);
            }
            return editor.getSelectionModel().getSelectedText();
        })) == null) {
            text = editor.getDocument().getText();
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return null;
        }
        return text;
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromFile(@NotNull VirtualFile file, @NotNull Project project, @Nullable String prefix) {
        if (file == null) {
            GithubCreateGistAction.$$$reportNull$$$0(16);
        }
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(17);
        }
        if (file.isDirectory()) {
            List<GithubGistRequest.FileContent> list2 = GithubCreateGistAction.getContentFromDirectory(file, project, prefix);
            if (list2 == null) {
                GithubCreateGistAction.$$$reportNull$$$0(18);
            }
            return list2;
        }
        if (file.getFileType().isBinary()) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Can't upload binary file: " + file);
            List<GithubGistRequest.FileContent> list3 = Collections.emptyList();
            if (list3 == null) {
                GithubCreateGistAction.$$$reportNull$$$0(19);
            }
            return list3;
        }
        String content = (String)ReadAction.compute(() -> {
            if (file == null) {
                GithubCreateGistAction.$$$reportNull$$$0(29);
            }
            try {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    return document.getText();
                }
                return new String(file.contentsToByteArray(), file.getCharset());
            }
            catch (IOException e) {
                LOG.info("Couldn't read contents of the file " + file, (Throwable)e);
                return null;
            }
        });
        if (content == null) {
            GithubNotifications.showWarning(project, FAILED_TO_CREATE_GIST, "Couldn't read the contents of the file " + file);
            List<GithubGistRequest.FileContent> list4 = Collections.emptyList();
            if (list4 == null) {
                GithubCreateGistAction.$$$reportNull$$$0(20);
            }
            return list4;
        }
        if (StringUtil.isEmptyOrSpaces((String)content)) {
            List<GithubGistRequest.FileContent> list5 = Collections.emptyList();
            if (list5 == null) {
                GithubCreateGistAction.$$$reportNull$$$0(21);
            }
            return list5;
        }
        String filename = GithubCreateGistAction.addPrefix(file.getName(), prefix, false);
        List<GithubGistRequest.FileContent> list6 = Collections.singletonList(new GithubGistRequest.FileContent(filename, content));
        if (list6 == null) {
            GithubCreateGistAction.$$$reportNull$$$0(22);
        }
        return list6;
    }

    @NotNull
    private static List<GithubGistRequest.FileContent> getContentFromDirectory(@NotNull VirtualFile dir, @NotNull Project project, @Nullable String prefix) {
        if (dir == null) {
            GithubCreateGistAction.$$$reportNull$$$0(23);
        }
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(24);
        }
        ArrayList<GithubGistRequest.FileContent> contents = new ArrayList<GithubGistRequest.FileContent>();
        for (VirtualFile file : dir.getChildren()) {
            if (GithubCreateGistAction.isFileIgnored(file, project)) continue;
            String pref = GithubCreateGistAction.addPrefix(dir.getName(), prefix, true);
            contents.addAll(GithubCreateGistAction.getContentFromFile(file, project, pref));
        }
        ArrayList<GithubGistRequest.FileContent> arrayList = contents;
        if (arrayList == null) {
            GithubCreateGistAction.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    private static String addPrefix(@NotNull String name, @Nullable String prefix, boolean addTrailingSlash) {
        if (name == null) {
            GithubCreateGistAction.$$$reportNull$$$0(26);
        }
        String pref = prefix == null ? "" : prefix;
        pref = pref + name;
        if (addTrailingSlash) {
            pref = pref + "_";
        }
        return pref;
    }

    private static boolean isFileIgnored(@NotNull VirtualFile file, @NotNull Project project) {
        ChangeListManager manager;
        if (file == null) {
            GithubCreateGistAction.$$$reportNull$$$0(27);
        }
        if (project == null) {
            GithubCreateGistAction.$$$reportNull$$$0(28);
        }
        return (manager = ChangeListManager.getInstance((Project)project)).isIgnoredFile(file) || FileTypeManager.getInstance().isFileIgnored(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 17: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/github/GithubCreateGistAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectContents";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFromFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentFromDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createGistAction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectContents";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createGist";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromEditor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromFile";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getContentFromDirectory";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addPrefix";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isFileIgnored";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContentFromFile$1";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getContentFromEditor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

