/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.AddServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.BaseStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseScenarioStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseServerStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.CreateProjectModel;
import com.jetbrains.plugins.webDeployment.actions.createproject.PublishOptionsStep;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecifyLocalPathStep
extends BaseStep {
    public static final Object ID = SpecifyLocalPathStep.class;
    private TextFieldWithBrowseButton myPathField;
    private JPanel myContentPane;
    private JTextField myProjectNameField;
    private JLabel myPathLabel;
    private JLabel myMessageLabel;
    private JRadioButton myDefaultOptionsRB;
    private JRadioButton myCustomOptionsRB;

    public SpecifyLocalPathStep(CreateProjectModel model) {
        super(WDBundle.message("create.web.project.choose.local.path.step.title", new Object[0]), model);
        this.$$$setupUI$$$();
        this.myPathLabel.setLabelFor(this.myPathField.getTextField());
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myProjectNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                File file;
                File baseDir;
                String oldText;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!StringUtil.isEmpty((String)(oldText = SpecifyLocalPathStep.this.myPathField.getText())) && (FileUtil.filesEqual((File)(baseDir = new File(SpecifyLocalPathStep.getDefaultBaseDir())), (File)(file = new File(oldText))) || FileUtil.filesEqual((File)baseDir, (File)file.getParentFile()))) {
                    SpecifyLocalPathStep.this.myPathField.setText(new File(baseDir, SpecifyLocalPathStep.this.myProjectNameField.getText()).getPath());
                }
                SpecifyLocalPathStep.this.updateLabel();
                SpecifyLocalPathStep.this.fireStateChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/actions/createproject/SpecifyLocalPathStep$1", "textChanged"));
            }
        });
        this.myPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                SpecifyLocalPathStep.this.updateLabel();
                SpecifyLocalPathStep.this.fireStateChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/actions/createproject/SpecifyLocalPathStep$2", "textChanged"));
            }
        });
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> listener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(null, "", (ComponentWithBrowseButton)this.myPathField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                SpecifyLocalPathStep.this.myPathField.setText(chosenFile.getPath());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/plugins/webDeployment/actions/createproject/SpecifyLocalPathStep$3", "onFileChosen"));
            }
        };
        this.myPathField.addActionListener((ActionListener)listener);
        ActionListener rbListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpecifyLocalPathStep.this.fireStateChanged();
            }
        };
        this.myDefaultOptionsRB.addActionListener(rbListener);
        this.myCustomOptionsRB.addActionListener(rbListener);
    }

    static String getDefaultBaseDir() {
        return ProjectUtil.getBaseDir();
    }

    private void updateLabel() {
        String errorMessage = this.validate();
        this.myMessageLabel.setText(errorMessage);
        this.myMessageLabel.setVisible(errorMessage != null);
    }

    @NotNull
    public Object getStepId() {
        Object object = ID;
        if (object == null) {
            SpecifyLocalPathStep.$$$reportNull$$$0(0);
        }
        return object;
    }

    public Object getNextStepId() {
        if (this.myCustomOptionsRB.isSelected()) {
            return PublishOptionsStep.ID;
        }
        return CreateProjectModel.getServers(this.myModel.scenario).isEmpty() ? AddServerStep.ID : ChooseServerStep.ID;
    }

    public Object getPreviousStepId() {
        return ChooseScenarioStep.ID;
    }

    public boolean isComplete() {
        if (this.myModel.scenario == CreateProjectModel.Scenario.NoServer || this.myModel.scenario == CreateProjectModel.Scenario.LocalServer) {
            return true;
        }
        return this.validate() == null;
    }

    @Nullable
    private String validate() {
        if (StringUtil.isEmpty((String)this.myProjectNameField.getText())) {
            return WDBundle.message("project.name.empty", new Object[0]);
        }
        if (StringUtil.isEmpty((String)this.myPathField.getText())) {
            return WDBundle.message("path.empty", new Object[0]);
        }
        if (this.myPathField.getText().startsWith("\\\\")) {
            return WDBundle.message("unc.path.not.supported", this.myPathField.getText());
        }
        return null;
    }

    private File getProjectPath() {
        File path = new File(this.myPathField.getText());
        try {
            return path.getCanonicalFile();
        }
        catch (IOException ignored) {
            return path;
        }
    }

    public void commit(AbstractWizardStepEx.CommitType commitType) throws CommitStepException {
        this.myModel.projectName = this.myProjectNameField.getText();
        this.myModel.localPath = this.getProjectPath().getPath();
        if (this.myDefaultOptionsRB.isSelected()) {
            this.myModel.resetConfig();
        }
        this.myModel.setDefaultConfigUsed(this.myDefaultOptionsRB.isSelected());
    }

    @Override
    public JComponent getInnerComponent() {
        return this.myContentPane;
    }

    @Override
    public void doInit() {
        String projectName = this.myModel.projectName;
        String localPath = this.myModel.localPath;
        if (StringUtil.isEmpty((String)localPath)) {
            File defaultProjectLocation = FileUtil.findSequentNonexistentFile((File)new File(SpecifyLocalPathStep.getDefaultBaseDir()), (String)"untitled", (String)"");
            projectName = defaultProjectLocation.getName();
            localPath = defaultProjectLocation.getPath();
        }
        this.myProjectNameField.setText(projectName);
        this.myPathField.setText(localPath);
        this.myProjectNameField.selectAll();
        this.updateLabel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myProjectNameField;
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.from.existing.files.specify.local.path";
    }

    @Override
    @Nls
    @NotNull
    protected String getSummaryText() {
        String string = WDBundle.message("create.web.project.specify.local.path.step.summary", new Object[0]);
        if (string == null) {
            SpecifyLocalPathStep.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/SpecifyLocalPathStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummaryText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JLabel jLabel;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Project name:");
        jLabel3.setDisplayedMnemonic('R');
        jLabel3.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        this.myPathLabel = jLabel2 = new JLabel();
        jLabel2.setText("Project local path:");
        jLabel2.setDisplayedMnemonic('L');
        jLabel2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 0, 1, 3, 0, 1, 6, 0, null, null, null));
        this.myProjectNameField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 0, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(9, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Deployment options (can be changed later at Settings | Deployment | Options panel):");
        jPanel.add((Component)jLabel4, new GridConstraints(6, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myDefaultOptionsRB = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Default");
        jRadioButton2.setMnemonic('D');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton2, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomOptionsRB = jRadioButton = new JRadioButton();
        jRadioButton.setText("Custom");
        jRadioButton.setMnemonic('C');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton, new GridConstraints(7, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(65, 22), null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(7, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

