/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"createUrlToLocalMap", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "mappings", "", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "findByName", "filename", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.debugger"})
public final class RemoteDebuggingFileFinderKt {
    @NotNull
    public static final BiMap<String, VirtualFile> createUrlToLocalMap(@NotNull List<? extends RemoteUrlMappingBean> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        if (mappings.isEmpty()) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableBiMap, (String)"ImmutableBiMap.of()");
            return (BiMap)immutableBiMap;
        }
        HashBiMap map = HashBiMap.create((int)mappings.size());
        for (RemoteUrlMappingBean remoteUrlMappingBean : mappings) {
            VirtualFile file = LocalFileFinder.findFile((String)remoteUrlMappingBean.localFilePath);
            if (file == null) continue;
            map.forcePut((Object)remoteUrlMappingBean.getRemoteUrl(), (Object)file);
        }
        HashBiMap hashBiMap = map;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashBiMap, (String)"map");
        return (BiMap)hashBiMap;
    }

    @Nullable
    public static final List<VirtualFile> findByName(@NotNull String filename, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return (List)DumbService.getInstance((Project)project).tryRunReadActionInSmartMode((Computable)new Computable<List<? extends VirtualFile>>(project, filename){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $filename;

            @NotNull
            public final List<VirtualFile> compute() {
                GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"ProjectScope.getContentScope(project)");
                GlobalSearchScope scope = globalSearchScope;
                CharSequence charSequence = this.$filename;
                Project project = this.$project;
                boolean bl = charSequence.length() == 0;
                Collection collection = FilenameIndex.getVirtualFilesByName((Project)project, (String)(bl ? "index.html" : this.$filename), (GlobalSearchScope)scope);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"FilenameIndex.getVirtual\u2026ml\" else filename, scope)");
                Collection files2 = collection;
                if (files2.isEmpty() && (charSequence = (CharSequence)this.$filename).length() == 0) {
                    Collection collection2 = FilenameIndex.getVirtualFilesByName((Project)this.$project, (String)"index.xhtml", (GlobalSearchScope)scope);
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"FilenameIndex.getVirtual\u2026ct, \"index.xhtml\", scope)");
                    files2 = collection2;
                }
                if (files2.isEmpty()) {
                    return CollectionsKt.emptyList();
                }
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
                ProjectFileIndex projectFileIndex2 = projectFileIndex;
                SmartList result2 = new SmartList();
                for (VirtualFile file : files2) {
                    if (projectFileIndex2.isInLibrarySource(file) || projectFileIndex2.isInLibraryClasses(file)) continue;
                    result2.add((Object)file);
                }
                return (List)result2;
            }
            {
                this.$project = project;
                this.$filename = string;
            }
        }, "Smart remote file mapping is not possible during index update");
    }
}

