/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.NodeLayout;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.util.ArrayUtil;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import org.jetbrains.annotations.Nullable;

public class MoveSelectionWrapper
extends AbstractAction {
    private final Graph2D myGraph;
    private final Keys myKey;
    private final DiagramBuilder myBuilder;

    public MoveSelectionWrapper(Keys key, DiagramBuilder builder) {
        this(key, builder.getGraph(), builder);
    }

    public MoveSelectionWrapper(Keys key, Graph2D graph) {
        this(key, graph, null);
    }

    private MoveSelectionWrapper(Keys key, Graph2D graph, @Nullable DiagramBuilder builder) {
        this.myKey = key;
        this.myGraph = graph;
        this.myBuilder = builder;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List selectedNodes = GraphViewUtil.getSelectedNodes((Graph2D)this.myGraph);
        Node node = selectedNodes.size() == 0 ? (Node)ArrayUtil.getFirstElement((Object[])this.myGraph.getNodeArray()) : (Node)selectedNodes.get(0);
        if (node == null) {
            return;
        }
        this.myGraph.selectAllNodesAndBends(false);
        Node toSelect = this.findNearestNode(node);
        this.myGraph.setSelected(toSelect, true);
        this.myGraph.updateViews();
    }

    private Node findNearestNode(Node node) {
        Node n;
        double angle = this.myKey.isUpDownKey() ? 2.356194490192345 : 0.5235987755982988;
        do {
            List<Node> nodes = new ArrayList<Node>(Arrays.asList(this.myGraph.getNodeArray()));
            nodes.remove(node);
            nodes = this.filterNodes(node, nodes, this.myKey, angle);
            n = this.findNearest(node, nodes);
            angle += this.myKey.isUpDownKey() ? 0.7853981633974483 : 2.6179938779914944;
        } while (n == node && (angle -= 0.001) < Math.PI);
        return n;
    }

    private Node findNearest(Node node, List<Node> nodes) {
        Node best = node;
        Point2D.Double coord = this.getNodeCoord(node);
        double distance = Double.MAX_VALUE;
        for (Node n : nodes) {
            double dist = coord.distance(this.getCoordOfNearestCorner(n, coord));
            if (!(distance > dist)) continue;
            best = n;
            distance = dist;
        }
        return best;
    }

    private List<Node> filterNodes(Node node, List<Node> nodes, Keys key, double angle) {
        ArrayList<Node> filtered = new ArrayList<Node>();
        for (Node n : nodes) {
            double alpha = this.calculateAngle(node, n, key);
            if (!(2.0 * Math.abs(alpha) <= angle)) continue;
            filtered.add(n);
        }
        return filtered;
    }

    private double calculateAngle(Node center, Node node, Keys key) {
        Segment nS;
        Segment cS;
        Point2D.Double a = this.getNodeCoord(center);
        Point2D.Double n = this.getNodeCoord(node);
        if (key.isUpDownKey() ? (key == Keys.UP && n.y < a.y || key == Keys.DOWN && n.y > a.y) && ((cS = MoveSelectionWrapper.getWidthSegment(center)).containsByX(nS = MoveSelectionWrapper.getWidthSegment(node)) || nS.containsByX(cS)) : (key == Keys.LEFT && n.x < a.x || key == Keys.RIGHT && n.x > a.x) && ((cS = MoveSelectionWrapper.getHeightSegment(center)).containsByY(nS = MoveSelectionWrapper.getHeightSegment(node)) || nS.containsByY(cS))) {
            return 0.0;
        }
        NodeLayout z = MoveSelectionWrapper.getLayout(node);
        double X = z.getX();
        double Y = z.getY();
        double W = z.getWidth();
        double H = z.getHeight();
        Point2D.Double[] points = new Point2D.Double[]{MoveSelectionWrapper.p(X + W / 2.0, Y + H / 2.0)};
        double angle = Math.PI * 2;
        for (Point2D.Double b : points) {
            int y;
            int n2 = key == Keys.UP ? -1 : (y = key == Keys.DOWN ? 1 : 0);
            int x = key == Keys.LEFT ? -1 : (key == Keys.RIGHT ? 1 : 0);
            Point2D.Double c = MoveSelectionWrapper.p(a.getX() + (double)x, a.getY() + (double)y);
            double A = b.distance(c);
            double B = a.distance(c);
            double C = a.distance(b);
            angle = Math.min(angle, Math.acos((B * B + C * C - A * A) / (2.0 * B * C)));
        }
        return angle;
    }

    private static Point2D.Double p(double x, double y) {
        return new Point2D.Double(x, y);
    }

    private Point2D.Double getNodeCoord(Node node) {
        NodeLayout layout = MoveSelectionWrapper.getLayout(node);
        return MoveSelectionWrapper.p(layout.getX() + layout.getWidth() / 2.0, layout.getY() + layout.getHeight() / 2.0);
    }

    private static NodeLayout getLayout(Node node) {
        return ((Graph2D)node.getGraph()).getNodeLayout((Object)node);
    }

    private static Segment getHeightSegment(Node node) {
        NodeLayout layout = MoveSelectionWrapper.getLayout(node);
        double x = layout.getX();
        double y = layout.getY();
        double h = layout.getHeight();
        return new Segment(x, y, x, y + h);
    }

    private static Segment getWidthSegment(Node node) {
        NodeLayout layout = MoveSelectionWrapper.getLayout(node);
        double x = layout.getX();
        double y = layout.getY();
        double w = layout.getWidth();
        return new Segment(x, y, x + w, y);
    }

    private Point2D.Double getCoordOfNearestCorner(Node node, Point2D.Double center) {
        NodeLayout layout = MoveSelectionWrapper.getLayout(node);
        double x = layout.getX();
        double y = layout.getY();
        double w = layout.getWidth();
        double h = layout.getHeight();
        Point2D.Double best = MoveSelectionWrapper.p(x, y);
        double dist = center.distance(x, y);
        if (dist > center.distance(x + w, y)) {
            best = MoveSelectionWrapper.p(x + w, y);
            dist = center.distance(best);
        }
        if (dist > center.distance(x, y + h)) {
            best = MoveSelectionWrapper.p(x, y + h);
            dist = center.distance(best);
        }
        if (dist > center.distance(x + w, y + h)) {
            best = MoveSelectionWrapper.p(x + w, y + h);
            dist = center.distance(best);
        }
        if (dist > center.distance(x + w / 2.0, y + h / 2.0)) {
            best = MoveSelectionWrapper.p(x + w / 2.0, y + h / 2.0);
        }
        return best;
    }

    public static class Segment {
        public final Point2D.Double X;
        public final Point2D.Double Y;

        public Segment(double x0, double y0, double x1, double y1) {
            this.X = MoveSelectionWrapper.p(x0, y0);
            this.Y = MoveSelectionWrapper.p(x1, y1);
        }

        public boolean containsByX(Segment s) {
            return this.inByX(s.X.x) && this.inByX(s.Y.x);
        }

        public boolean containsByY(Segment s) {
            return this.inByY(s.X.y) && this.inByY(s.Y.y);
        }

        public boolean intersectsByX(Segment s) {
            return this.inByX(s.X.x) || this.inByX(s.Y.x) || s.inByX(this.X.x) || s.inByX(this.Y.x);
        }

        public boolean intersectsByY(Segment s) {
            return this.inByY(s.X.y) || this.inByY(s.Y.y) || s.inByY(this.X.y) || s.inByY(this.Y.y);
        }

        public boolean inByX(double x) {
            return this.X.x <= x && x <= this.Y.x || this.Y.x <= x && x <= this.X.x;
        }

        public boolean inByY(double y) {
            return this.X.y <= y && y <= this.Y.y || this.Y.y <= y && y <= this.X.y;
        }
    }

    public static enum Keys {
        UP,
        DOWN,
        LEFT,
        RIGHT;


        boolean isUpDownKey() {
            return this == UP || this == DOWN;
        }
    }
}

