/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionsPassFactory
implements MainHighlightingPassFactory {
    private static final Logger LOG = Logger.getInstance(LocalInspectionsPassFactory.class);
    private final Project myProject;

    public LocalInspectionsPassFactory(Project project, TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myProject = project;
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, true, 7);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        TextRange textRange;
        if (file2 == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(1);
        }
        if ((textRange = LocalInspectionsPassFactory.calculateRangeToProcess(editor)) == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(this.myProject, editor.getDocument());
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new MyLocalInspectionsPass(file2, editor.getDocument(), textRange, (TextRange)visibleRange, new DefaultHighlightInfoProcessor());
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        TextRange textRange;
        if (file2 == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(2);
        }
        if (document == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(3);
        }
        if (highlightInfoProcessor == null) {
            LocalInspectionsPassFactory.$$$reportNull$$$0(4);
        }
        LOG.assertTrue((textRange = file2.getTextRange()) != null, (Object)("textRange is null for " + file2 + " (" + PsiUtilCore.getVirtualFile((PsiElement)file2) + ")"));
        return new MyLocalInspectionsPass(file2, document, textRange, LocalInspectionsPass.EMPTY_PRIORITY_RANGE, highlightInfoProcessor);
    }

    private static TextRange calculateRangeToProcess(Editor editor) {
        return FileStatusMap.getDirtyTextRange(editor, 7);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createMainHighlightingPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLocalInspectionsPass
    extends LocalInspectionsPass {
        private MyLocalInspectionsPass(@NotNull PsiFile file2, Document document, @NotNull TextRange textRange, @NotNull TextRange visibleRange, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            if (file2 == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(0);
            }
            if (textRange == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(1);
            }
            if (visibleRange == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(2);
            }
            if (highlightInfoProcessor == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(3);
            }
            super(file2, document, textRange.getStartOffset(), textRange.getEndOffset(), visibleRange, true, highlightInfoProcessor);
        }

        @Override
        @NotNull
        List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile2) {
            if (profile2 == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(4);
            }
            List<LocalInspectionToolWrapper> tools = super.getInspectionTools(profile2);
            ArrayList<LocalInspectionToolWrapper> result2 = new ArrayList<LocalInspectionToolWrapper>(tools.size());
            for (LocalInspectionToolWrapper tool : tools) {
                if (tool.runForWholeFile()) continue;
                result2.add(tool);
            }
            ArrayList<LocalInspectionToolWrapper> arrayList = result2;
            if (arrayList == null) {
                MyLocalInspectionsPass.$$$reportNull$$$0(5);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visibleRange";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightInfoProcessor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory$MyLocalInspectionsPass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/LocalInspectionsPassFactory$MyLocalInspectionsPass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInspectionTools";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getInspectionTools";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

