/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.ui.BaseChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.DirectoryChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import java.util.Map;
import java.util.function.Function;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J \u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J \u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0001J \u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\"\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/BaseChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "innerPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicy;", "getModel", "()Ljavax/swing/tree/DefaultTreeModel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getParentFromInnerPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "subtreeRoot", "getParentNodeFor", "getParentNodeInternal", "getParentNodeRecursive", "getPathNode", "Companion", "Factory", "intellij.platform.vcs.impl"})
public final class DirectoryChangesGroupingPolicy
extends BaseChangesGroupingPolicy {
    private final ChangesGroupingPolicy innerPolicy;
    @NotNull
    private final Project project;
    @NotNull
    private final DefaultTreeModel model;
    @JvmField
    @NotNull
    public static final Key<DirectoryChangesGroupingPolicy> DIRECTORY_POLICY;
    @NotNull
    private static final Key<ChangesBrowserNode<?>> GRAND_PARENT_CANDIDATE;
    @NotNull
    private static final Key<ChangesBrowserNode<?>> HIERARCHY_UPPER_BOUND;
    @NotNull
    private static final Key<ChangesBrowserNode<?>> CACHING_ROOT;
    public static final Companion Companion;

    @NotNull
    public ChangesBrowserNode<?> getParentNodeFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        Intrinsics.checkParameterIsNotNull((Object)nodePath, (String)"nodePath");
        Intrinsics.checkParameterIsNotNull(subtreeRoot, (String)"subtreeRoot");
        DIRECTORY_POLICY.set((UserDataHolder)subtreeRoot, (Object)this);
        Object object = this.getNextPolicy();
        if (object == null || (object = object.getParentNodeFor(nodePath, subtreeRoot)) == null) {
            object = subtreeRoot;
        }
        Object grandParent = object;
        HIERARCHY_UPPER_BOUND.set((UserDataHolder)subtreeRoot, grandParent);
        CACHING_ROOT.set((UserDataHolder)subtreeRoot, BaseChangesGroupingPolicy.Companion.getCachingRoot((ChangesBrowserNode<?>)grandParent, subtreeRoot));
        return this.getParentNodeRecursive(nodePath, subtreeRoot);
    }

    private final ChangesBrowserNode<?> getParentNodeRecursive(StaticFilePath nodePath, ChangesBrowserNode<?> subtreeRoot) {
        ChangesBrowserNode<?> changesBrowserNode = this.getParentFromInnerPolicy(nodePath, subtreeRoot);
        if (changesBrowserNode == null) {
            changesBrowserNode = this.getParentNodeInternal(nodePath, subtreeRoot);
        }
        return changesBrowserNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmName(name="getParentNodeInternal")
    @NotNull
    public final ChangesBrowserNode<?> getParentNodeInternal(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> subtreeRoot) {
        Intrinsics.checkParameterIsNotNull((Object)nodePath, (String)"nodePath");
        Intrinsics.checkParameterIsNotNull(subtreeRoot, (String)"subtreeRoot");
        Sequence $receiver$iv = SequencesKt.generateSequence((Object)nodePath.getParent(), (Function1)getParentNodeInternal.1.INSTANCE);
        for (Object element$iv : $receiver$iv) {
            ChangesBrowserNode<?> changesBrowserNode;
            StaticFilePath parentPath = (StaticFilePath)element$iv;
            ChangesBrowserNode<?> cachingRoot = Companion.getCachingRoot$intellij_platform_vcs_impl(subtreeRoot);
            Map map = (Map)TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)cachingRoot);
            StaticFilePath staticFilePath = parentPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)staticFilePath, (String)"parentPath");
            ChangesBrowserNode<?> changesBrowserNode2 = (ChangesBrowserNode<?>)map.get(staticFilePath.getKey());
            if (changesBrowserNode2 != null) {
                ChangesBrowserNode<?> changesBrowserNode3;
                ChangesBrowserNode<?> it = changesBrowserNode3 = changesBrowserNode2;
                if (Intrinsics.areEqual((Object)((ChangesBrowserNode)HIERARCHY_UPPER_BOUND.get((UserDataHolder)subtreeRoot)), (Object)it)) {
                    GRAND_PARENT_CANDIDATE.set((UserDataHolder)subtreeRoot, (Object)it);
                    try {
                        ChangesBrowserNode<?> changesBrowserNode4;
                        ChangesBrowserNode<?> changesBrowserNode5 = this.getParentFromInnerPolicy(parentPath, subtreeRoot);
                        if (changesBrowserNode5 == null) {
                            changesBrowserNode5 = changesBrowserNode4 = this.getPathNode(parentPath, subtreeRoot);
                        }
                        if (changesBrowserNode5 == null) {
                            changesBrowserNode4 = it;
                        }
                        ChangesBrowserNode<?> changesBrowserNode6 = changesBrowserNode4;
                        return changesBrowserNode6;
                    }
                    finally {
                        GRAND_PARENT_CANDIDATE.set((UserDataHolder)subtreeRoot, null);
                    }
                }
                return it;
            }
            ChangesBrowserNode<?> changesBrowserNode7 = this.getPathNode(parentPath, subtreeRoot);
            if (changesBrowserNode7 == null) continue;
            ChangesBrowserNode<?> it = changesBrowserNode = changesBrowserNode7;
            return it;
        }
        Object object = HIERARCHY_UPPER_BOUND.getRequired((UserDataHolder)subtreeRoot);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"HIERARCHY_UPPER_BOUND.getRequired(subtreeRoot)");
        return (ChangesBrowserNode)object;
    }

    private final ChangesBrowserNode<?> getParentFromInnerPolicy(StaticFilePath nodePath, ChangesBrowserNode<?> subtreeRoot) {
        Object object = this.innerPolicy;
        if (object != null && (object = object.getParentNodeFor(nodePath, subtreeRoot)) != null) {
            Object object2;
            Object it = object2 = object;
            ((ChangesBrowserNode)it).markAsHelperNode();
            return it;
        }
        return null;
    }

    private final ChangesBrowserNode<?> getPathNode(StaticFilePath nodePath, ChangesBrowserNode<?> subtreeRoot) {
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)((Function)TreeModelBuilder.PATH_NODE_BUILDER.getRequired((UserDataHolder)subtreeRoot)).apply(nodePath);
        if (changesBrowserNode != null) {
            ChangesBrowserNode changesBrowserNode2;
            ChangesBrowserNode it = changesBrowserNode2 = changesBrowserNode;
            it.markAsHelperNode();
            ChangesBrowserNode<?> changesBrowserNode3 = (ChangesBrowserNode<?>)GRAND_PARENT_CANDIDATE.get((UserDataHolder)subtreeRoot);
            if (changesBrowserNode3 == null) {
                changesBrowserNode3 = this.getParentNodeRecursive(nodePath, subtreeRoot);
            }
            ChangesBrowserNode<?> grandParent = changesBrowserNode3;
            ChangesBrowserNode<?> cachingRoot = Companion.getCachingRoot$intellij_platform_vcs_impl(subtreeRoot);
            this.model.insertNodeInto(it, grandParent, grandParent.getChildCount());
            Object object = TreeModelBuilder.DIRECTORY_CACHE.getValue((UserDataHolder)cachingRoot);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"DIRECTORY_CACHE.getValue(cachingRoot)");
            Map map = (Map)object;
            String string = nodePath.getKey();
            ChangesBrowserNode changesBrowserNode4 = it;
            map.put(string, changesBrowserNode4);
            return it;
        }
        return null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DefaultTreeModel getModel() {
        return this.model;
    }

    public DirectoryChangesGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        this.project = project;
        this.model = model;
        ChangesGroupingPolicyFactory changesGroupingPolicyFactory = ChangesGroupingPolicyFactory.getInstance(this.project);
        this.innerPolicy = changesGroupingPolicyFactory != null ? changesGroupingPolicyFactory.createGroupingPolicy(this.model) : null;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"ChangesTree.DirectoryPolicy");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<DirectoryChan\u2026gesTree.DirectoryPolicy\")");
        DIRECTORY_POLICY = key;
        Key key2 = Key.create((String)"ChangesTree.GrandParentCandidate");
        Intrinsics.checkExpressionValueIsNotNull((Object)key2, (String)"Key.create<ChangesBrowse\u2026ee.GrandParentCandidate\")");
        GRAND_PARENT_CANDIDATE = key2;
        Key key3 = Key.create((String)"ChangesTree.HierarchyUpperBound");
        Intrinsics.checkExpressionValueIsNotNull((Object)key3, (String)"Key.create<ChangesBrowse\u2026ree.HierarchyUpperBound\")");
        HIERARCHY_UPPER_BOUND = key3;
        Key key4 = Key.create((String)"ChangesTree.CachingRoot");
        Intrinsics.checkExpressionValueIsNotNull((Object)key4, (String)"Key.create<ChangesBrowse\u2026ChangesTree.CachingRoot\")");
        CACHING_ROOT = key4;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @NotNull
        private final Project project;

        @Override
        @NotNull
        public DirectoryChangesGroupingPolicy createGroupingPolicy(@NotNull DefaultTreeModel model) {
            Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
            return new DirectoryChangesGroupingPolicy(this.project, model);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public Factory(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            this.project = project;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0000\u00a2\u0006\u0002\b\u0011R \u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007R \u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy$Companion;", "", "()V", "CACHING_ROOT", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "getCACHING_ROOT$intellij_platform_vcs_impl", "()Lcom/intellij/openapi/util/Key;", "DIRECTORY_POLICY", "Lcom/intellij/openapi/vcs/changes/ui/DirectoryChangesGroupingPolicy;", "kotlin.jvm.PlatformType", "GRAND_PARENT_CANDIDATE", "getGRAND_PARENT_CANDIDATE$intellij_platform_vcs_impl", "HIERARCHY_UPPER_BOUND", "getHIERARCHY_UPPER_BOUND$intellij_platform_vcs_impl", "getCachingRoot", "subtreeRoot", "getCachingRoot$intellij_platform_vcs_impl", "intellij.platform.vcs.impl"})
    public static final class Companion {
        @NotNull
        public final Key<ChangesBrowserNode<?>> getGRAND_PARENT_CANDIDATE$intellij_platform_vcs_impl() {
            return GRAND_PARENT_CANDIDATE;
        }

        @NotNull
        public final Key<ChangesBrowserNode<?>> getHIERARCHY_UPPER_BOUND$intellij_platform_vcs_impl() {
            return HIERARCHY_UPPER_BOUND;
        }

        @NotNull
        public final Key<ChangesBrowserNode<?>> getCACHING_ROOT$intellij_platform_vcs_impl() {
            return CACHING_ROOT;
        }

        @NotNull
        public final ChangesBrowserNode<?> getCachingRoot$intellij_platform_vcs_impl(@NotNull ChangesBrowserNode<?> subtreeRoot) {
            Intrinsics.checkParameterIsNotNull(subtreeRoot, (String)"subtreeRoot");
            ChangesBrowserNode<?> changesBrowserNode = (ChangesBrowserNode<?>)this.getCACHING_ROOT$intellij_platform_vcs_impl().get((UserDataHolder)subtreeRoot);
            if (changesBrowserNode == null) {
                changesBrowserNode = subtreeRoot;
            }
            return changesBrowserNode;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

