/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"HEIGHT_ATTR", "", "WIDTH_ATTR", "X_ATTR", "Y_ATTR", "deserializeBounds", "Ljava/awt/Rectangle;", "element", "Lorg/jdom/Element;", "serializeBounds", "", "bounds", "getFrameInfoInDeviceSpace", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "Lcom/intellij/openapi/wm/impl/WindowManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ide.impl"})
public final class ProjectFrameBoundsKt {
    private static final String X_ATTR = "x";
    private static final String Y_ATTR = "y";
    private static final String WIDTH_ATTR = "width";
    private static final String HEIGHT_ATTR = "height";

    @Nullable
    public static final FrameInfo getFrameInfoInDeviceSpace(@NotNull WindowManagerImpl $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        IdeFrameImpl ideFrameImpl = $receiver.getFrame(project);
        if (ideFrameImpl == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ideFrameImpl, (String)"getFrame(project) ?: return null");
        IdeFrameImpl frame = ideFrameImpl;
        int extendedState = $receiver.updateFrameBounds(frame);
        FrameInfo frameInfo = new FrameInfo();
        GraphicsConfiguration graphicsConfiguration = frame.getGraphicsConfiguration();
        Rectangle rectangle = $receiver.myDefaultFrameInfo.getBounds();
        if (rectangle == null) {
            Intrinsics.throwNpe();
        }
        frameInfo.setBounds(WindowManagerImpl.FrameBoundsConverter.convertToDeviceSpace(graphicsConfiguration, rectangle));
        frameInfo.setExtendedState(extendedState);
        if ($receiver.isFullScreenSupportedInCurrentOS()) {
            frameInfo.setFullScreen(frame.isInFullScreen());
        }
        return frameInfo;
    }

    public static final void serializeBounds(@NotNull Rectangle bounds2, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)bounds2, (String)"bounds");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        element.setAttribute(X_ATTR, Integer.toString(bounds2.x));
        element.setAttribute(Y_ATTR, Integer.toString(bounds2.y));
        element.setAttribute(WIDTH_ATTR, Integer.toString(bounds2.width));
        element.setAttribute(HEIGHT_ATTR, Integer.toString(bounds2.height));
    }

    @Nullable
    public static final Rectangle deserializeBounds(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        try {
            String string = element.getAttributeValue(X_ATTR);
            if (string == null) {
                return null;
            }
            String string2 = string;
            int x = Integer.parseInt(string2);
            String string3 = element.getAttributeValue(Y_ATTR);
            if (string3 == null) {
                return null;
            }
            String string4 = string3;
            int y = Integer.parseInt(string4);
            String string5 = element.getAttributeValue(WIDTH_ATTR);
            if (string5 == null) {
                return null;
            }
            String string6 = string5;
            int w = Integer.parseInt(string6);
            String string7 = element.getAttributeValue(HEIGHT_ATTR);
            if (string7 == null) {
                return null;
            }
            String string8 = string7;
            int h = Integer.parseInt(string8);
            return new Rectangle(x, y, w, h);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

