/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.epp.ide.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.lang.puppet.epp.EppFileType;
import com.intellij.lang.puppet.epp.elementTypes.EppElementTypes;
import com.intellij.lang.puppet.epp.ide.editor.EppSmartKeysUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;

public class EppBackSpaceHandler
extends BackspaceHandlerDelegate {
    private boolean isCharDeleted;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        this.isCharDeleted = false;
        if (file.getVirtualFile().getFileType() != EppFileType.INSTANCE) {
            return;
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int currentOffset = caretModel.getOffset();
        if (c == '|') {
            if (EppSmartKeysUtil.getTokenInfo((Editor)editor, (int)(currentOffset - 1)).tokenType == EppElementTypes.EPP_PARAMETER_OPENER) {
                EppSmartKeysUtil.TokenInfo nextEppTokenInfo = EppSmartKeysUtil.getNextEppTokenInfo(editor, currentOffset);
                if (nextEppTokenInfo.tokenType == EppElementTypes.EPP_PARAMETER_CLOSER) {
                    document.deleteString(nextEppTokenInfo.startOffset, nextEppTokenInfo.startOffset + 2);
                }
                this.isCharDeleted = true;
            } else if (EppSmartKeysUtil.getTokenInfo((Editor)editor, (int)currentOffset).tokenType == EppElementTypes.EPP_PARAMETER_CLOSER) {
                EppSmartKeysUtil.TokenInfo prevEppTokenInfo = EppSmartKeysUtil.getPrevEppTokenInfo(editor, currentOffset - 2);
                if (prevEppTokenInfo.tokenType == EppElementTypes.EPP_PARAMETER_OPENER) {
                    document.deleteString(prevEppTokenInfo.endOffset - 1, prevEppTokenInfo.endOffset);
                }
                this.isCharDeleted = true;
            }
        }
        if (c == '%') {
            EppSmartKeysUtil.TokenInfo currentTokenInfo = EppSmartKeysUtil.getTokenInfo(editor, currentOffset - 1);
            if (currentTokenInfo.tokenType == EppElementTypes.EPP_EXPRESSION_OPENER) {
                EppSmartKeysUtil.TokenInfo nextEppTokenInfo = EppSmartKeysUtil.getNextEppTokenInfo(editor, currentOffset);
                if (nextEppTokenInfo.tokenType == EppElementTypes.EPP_EXPRESSION_CLOSER) {
                    nextEppTokenInfo.deleteFrom(document);
                }
                document.deleteString(currentOffset - 1, currentOffset);
                caretModel.moveToOffset(currentOffset - 1);
                this.isCharDeleted = true;
            }
        }
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        return this.isCharDeleted;
    }
}

