/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.sablecc;

import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.sablecc.sablecc.In_Production;
import org.sablecc.sablecc.Inlining;
import org.sablecc.sablecc.SableCC;
import org.sablecc.sablecc.analysis.DepthFirstAdapter;
import org.sablecc.sablecc.node.AAlt;
import org.sablecc.sablecc.node.AElem;
import org.sablecc.sablecc.node.AGrammar;
import org.sablecc.sablecc.node.AProd;
import org.sablecc.sablecc.node.AProductions;
import org.sablecc.sablecc.node.ATokenSpecifier;
import org.sablecc.sablecc.node.PAlt;
import org.sablecc.sablecc.node.PElem;
import org.sablecc.sablecc.node.PProd;
import org.sablecc.sablecc.node.Start;

public class ComputeInlining {
    private Set setOfProdToBeInline;
    private Map productionsMap;
    private Start tree;

    public ComputeInlining(Set set, Map productionsMap, Start tree) {
        this.setOfProdToBeInline = set;
        this.productionsMap = productionsMap;
        this.tree = tree;
    }

    public boolean computeInlining() {
        final BooleanEx atLeastOneProductionInlined = new BooleanEx(false);
        String[] nameOfProds = this.setOfProdToBeInline.toArray(new String[0]);
        for (int i = 0; i < nameOfProds.length; ++i) {
            AProd prod;
            if (nameOfProds[i].equals("Start") || (prod = (AProd)this.productionsMap.get(nameOfProds[i])).getAlts().size() > SableCC.inliningMaxAlts || this.isProductionRecursive(prod)) continue;
            final In_Production in_production = new In_Production((AProd)prod.clone());
            this.tree.apply(new DepthFirstAdapter(){

                @Override
                public void caseAProd(AProd node) {
                    if (node.getId().getText().equals(prod.getId().getText())) {
                        return;
                    }
                    Inlining inliningClass = new Inlining(node, in_production);
                    if (inliningClass.inlineProduction() && !atLeastOneProductionInlined.getValue()) {
                        atLeastOneProductionInlined.setValue(true);
                    }
                }
            });
        }
        LinkedList<PProd> listOfGrammarProds = ((AProductions)((AGrammar)this.tree.getPGrammar()).getProductions()).getProds();
        String[] inlinedProductionsToRemove = Inlining.productionsToBeRemoved.toArray(new String[0]);
        for (int i = 0; i < inlinedProductionsToRemove.length; ++i) {
            listOfGrammarProds.remove(this.productionsMap.get(inlinedProductionsToRemove[i]));
        }
        Inlining.productionsToBeRemoved.clear();
        return atLeastOneProductionInlined.getValue();
    }

    public boolean isProductionRecursive(AProd production) {
        final BooleanEx recursive = new BooleanEx(false);
        final String currentProdName = production.getId().getText();
        production.apply(new DepthFirstAdapter(){

            @Override
            public void caseAProd(AProd node) {
                Object[] temp = node.getAlts().toArray();
                for (int i = 0; i < temp.length; ++i) {
                    ((PAlt)temp[i]).apply(this);
                }
            }

            @Override
            public void caseAAlt(AAlt node) {
                Object[] temp = node.getElems().toArray();
                for (int i = 0; i < temp.length; ++i) {
                    ((PElem)temp[i]).apply(this);
                }
            }

            @Override
            public void caseAElem(AElem node) {
                if (node.getId().getText().equals(currentProdName)) {
                    if (node.getSpecifier() != null && node.getSpecifier() instanceof ATokenSpecifier) {
                        return;
                    }
                    recursive.setValue(true);
                }
            }
        });
        return recursive.getValue();
    }

    class BooleanEx {
        boolean value;

        BooleanEx(boolean value) {
            this.value = value;
        }

        void setValue(boolean value) {
            this.value = value;
        }

        boolean getValue() {
            return this.value;
        }
    }
}

