/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf.borders;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.TinyLookAndFeel;
import net.sf.tinylaf.TinySpinnerButtonUI;
import net.sf.tinylaf.util.DrawRoutines;

public class TinyButtonBorder
extends AbstractBorder
implements UIResource {
    protected final Insets borderInsets = new Insets(2, 2, 2, 2);

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (!TinyLookAndFeel.controlPanelInstantiated) {
            return;
        }
        AbstractButton b = (AbstractButton)c;
        boolean isComboBoxButton = Boolean.TRUE.equals(b.getClientProperty("isComboBoxButton"));
        if (isComboBoxButton) {
            if (!b.isEnabled()) {
                DrawRoutines.drawRoundedBorder(g, Theme.comboBorderDisabledColor.getColor(), x, y, w, h);
            } else {
                DrawRoutines.drawRoundedBorder(g, Theme.comboBorderColor.getColor(), x, y, w, h);
                if (b.getModel().isPressed()) {
                    return;
                }
                if (b.getModel().isRollover() && Theme.comboRollover.getValue()) {
                    DrawRoutines.drawRolloverBorder(g, Theme.buttonRolloverColor.getColor(), x, y, w, h);
                }
            }
        } else {
            boolean paintRollover;
            boolean isSpinnerButton = Boolean.TRUE.equals(b.getClientProperty("isSpinnerButton"));
            boolean bl = paintRollover = isSpinnerButton && Theme.spinnerRollover.getValue() || !isSpinnerButton && Theme.buttonRolloverBorder.getValue();
            if (isSpinnerButton) {
                g.setColor(TinySpinnerButtonUI.getSpinnerParent(b).getBackground());
                g.drawRect(0, 0, w - 1, h - 1);
                g.setColor(TinySpinnerButtonUI.getSpinner(b).getBackground());
                if (Boolean.TRUE.equals(b.getClientProperty("isNextButton"))) {
                    g.drawLine(0, h - 1, 0, h - 1);
                } else {
                    g.drawLine(0, 0, 0, 0);
                }
                if (!b.isEnabled()) {
                    g.setColor(Theme.spinnerBorderDisabledColor.getColor());
                } else {
                    g.setColor(Theme.spinnerBorderColor.getColor());
                }
                g.drawLine(x + 1, y, x + w - 2, y);
                g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
                g.drawLine(x, y + 1, x, y + h - 2);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
                if (b.getModel().isPressed()) {
                    return;
                }
                if (b.getModel().isRollover() && paintRollover) {
                    DrawRoutines.drawRolloverBorder(g, Theme.buttonRolloverColor.getColor(), x, y, w, h);
                }
            } else {
                boolean isDefault;
                boolean bl2 = isDefault = c instanceof JButton && ((JButton)c).isDefaultButton();
                if (!b.isEnabled()) {
                    DrawRoutines.drawRoundedBorder(g, Theme.buttonBorderDisabledColor.getColor(), x, y, w, h);
                } else {
                    DrawRoutines.drawRoundedBorder(g, Theme.buttonBorderColor.getColor(), x, y, w, h);
                    if (b.getModel().isPressed()) {
                        return;
                    }
                    if (b.getModel().isRollover() && paintRollover) {
                        DrawRoutines.drawRolloverBorder(g, Theme.buttonRolloverColor.getColor(), x, y, w, h);
                    } else if (isDefault || Theme.buttonFocusBorder.getValue() && b.isFocusOwner() && b.isFocusPainted()) {
                        DrawRoutines.drawRolloverBorder(g, Theme.buttonDefaultColor.getColor(), x, y, w, h);
                    }
                }
            }
        }
    }

    public Insets getBorderInsets(Component c) {
        return this.borderInsets;
    }

    public static class CompoundBorderUIResource
    extends CompoundBorder
    implements UIResource {
        public CompoundBorderUIResource(Border outsideBorder, Border insideBorder) {
            super(outsideBorder, insideBorder);
        }
    }
}

