/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.util.ImageUtil;
import org.jmeld.ui.util.ToolBarBuilder;

public class FilePanelBar
extends JPanel {
    private FilePanel filePanel;
    private JLabel selected;
    private JLabel lineNumber;
    private JLabel columnNumber;
    private ImageIcon iconSelected;
    private ImageIcon iconNotSelected;

    public FilePanelBar(FilePanel filePanel) {
        this.filePanel = filePanel;
        this.init();
    }

    private void init() {
        this.selected = new JLabel();
        this.lineNumber = new JLabel();
        this.columnNumber = new JLabel();
        ToolBarBuilder builder = new ToolBarBuilder(this);
        builder.addComponent(this.selected);
        builder.addSpring();
        builder.addComponent(this.lineNumber);
        builder.addSeparator();
        builder.addComponent(this.columnNumber);
        this.iconSelected = ImageUtil.getImageIcon("panel-selected");
        this.iconNotSelected = ImageUtil.createTransparentIcon(this.iconSelected);
        this.update();
    }

    public void update() {
        int column;
        int line;
        ImageIcon icon;
        ImageIcon imageIcon = icon = this.filePanel.isSelected() ? this.iconSelected : this.iconNotSelected;
        if (this.selected.getIcon() != icon) {
            this.selected.setIcon(icon);
        }
        JTextArea editor = this.filePanel.getEditor();
        int caretPosition = editor.getCaretPosition();
        try {
            line = editor.getLineOfOffset(caretPosition);
        }
        catch (Exception ex) {
            line = -1;
        }
        try {
            column = caretPosition - editor.getLineStartOffset(line);
        }
        catch (Exception ex) {
            column = -1;
        }
        String text = String.format("Line: %05d/%05d", line + 1, editor.getLineCount());
        this.lineNumber.setText(text);
        text = String.format("Column: %03d", column);
        this.columnNumber.setText(text);
    }
}

