/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.sql.SQLException;
import java.util.List;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTree;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TreeLoader {
    private static final ILogger s_log = LoggerController.createLogger(TreeLoader.class);
    private ObjectTree objectTree;
    private ObjectTreeNode _parentNode;
    private INodeExpander[] _expanders;
    private boolean _selectParentNode;
    private ObjectTreeModel model;
    private ISession session;

    TreeLoader(ISession session, ObjectTree objectTree, ObjectTreeModel model, ObjectTreeNode parentNode, INodeExpander[] expanders, boolean selectParentNode) {
        this.session = session;
        this.objectTree = objectTree;
        this.model = model;
        this._parentNode = parentNode;
        this._expanders = expanders;
        this._selectParentNode = selectParentNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() {
        try {
            try {
                ObjectTreeNode loadingNode = this.showLoadingNode();
                try {
                    this.loadChildren();
                }
                finally {
                    if (this._parentNode.isNodeChild(loadingNode)) {
                        this._parentNode.remove(loadingNode);
                    }
                }
            }
            finally {
                this.fireStructureChanged(this._parentNode);
                if (this._selectParentNode) {
                    this.objectTree.clearSelection();
                    this.objectTree.setSelectionPath(new TreePath(this._parentNode.getPath()));
                }
            }
        }
        catch (Throwable ex) {
            String msg = "Error: " + this._parentNode.toString();
            s_log.error(msg, ex);
            this.session.showErrorMessage(msg + ": " + ex.toString());
        }
    }

    private ObjectTreeNode showLoadingNode() {
        DatabaseObjectInfo doi = new DatabaseObjectInfo(null, null, "Loading...", DatabaseObjectType.OTHER, this.session.getSQLConnection().getSQLMetaData());
        ObjectTreeNode loadingNode = new ObjectTreeNode(this.session, doi);
        this._parentNode.add(loadingNode);
        this.fireStructureChanged(this._parentNode);
        return loadingNode;
    }

    private void loadChildren() throws SQLException {
        boolean noChildrenFound = true;
        for (int i = 0; i < this._expanders.length; ++i) {
            boolean nodeTypeAllowsChildren = false;
            DatabaseObjectType lastDboType = null;
            List<ObjectTreeNode> list = this._expanders[i].createChildren(this.session, this._parentNode);
            if (!list.isEmpty()) {
                noChildrenFound = false;
            }
            for (ObjectTreeNode nextObj : list) {
                if (!(nextObj instanceof ObjectTreeNode)) continue;
                ObjectTreeNode childNode = nextObj;
                if (childNode.getExpanders().length > 0) {
                    childNode.setAllowsChildren(true);
                } else {
                    DatabaseObjectType childNodeDboType = childNode.getDatabaseObjectType();
                    if (childNodeDboType != lastDboType) {
                        this.objectTree.getTypedModel().addKnownDatabaseObjectType(childNodeDboType);
                        lastDboType = childNodeDboType;
                        nodeTypeAllowsChildren = this.model.getExpanders(childNodeDboType).length > 0;
                    }
                    childNode.setAllowsChildren(nodeTypeAllowsChildren);
                }
                this._parentNode.add(childNode);
            }
        }
        this._parentNode.setNoChildrenFoundWithExpander(noChildrenFound);
    }

    private void fireStructureChanged(final ObjectTreeNode node) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                TreeLoader.this.model.nodeStructureChanged(node);
            }
        });
    }
}

