/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UserType;

final class AbstractTypeVersionComparator
implements Comparator<AbstractType<?>> {
    public static final Comparator<AbstractType<?>> INSTANCE = new AbstractTypeVersionComparator();

    private AbstractTypeVersionComparator() {
    }

    @Override
    public int compare(AbstractType<?> type, AbstractType<?> otherType) {
        if (!type.getClass().equals(otherType.getClass())) {
            throw new IllegalArgumentException(String.format("Trying to compare 2 different types: %s and %s", type, otherType));
        }
        if (type.equals(otherType)) {
            return 0;
        }
        if (type.isUDT()) {
            return this.compareUserType((UserType)type, (UserType)otherType);
        }
        if (type.isTuple()) {
            return this.compareTuple((TupleType)type, (TupleType)otherType);
        }
        if (type.isCollection()) {
            return this.compareCollectionTypes(type, otherType);
        }
        if (type instanceof CompositeType) {
            return this.compareCompositeTypes((CompositeType)type, (CompositeType)otherType);
        }
        return 0;
    }

    private int compareCompositeTypes(CompositeType type, CompositeType otherType) {
        List<AbstractType<?>> types = type.getComponents();
        List<AbstractType<?>> otherTypes = otherType.getComponents();
        if (types.size() != otherTypes.size()) {
            return Integer.compare(types.size(), otherTypes.size());
        }
        int i = 0;
        int m = type.componentsCount();
        if (i < m) {
            int test = this.compare(types.get(i), otherTypes.get(i));
            if (test != 0) {
                // empty if block
            }
            return test;
        }
        return 0;
    }

    private int compareCollectionTypes(AbstractType<?> type, AbstractType<?> otherType) {
        if (type instanceof MapType) {
            return this.compareMapType((MapType)type, (MapType)otherType);
        }
        if (type instanceof SetType) {
            return this.compare(((SetType)type).getElementsType(), ((SetType)otherType).getElementsType());
        }
        return this.compare(((ListType)type).getElementsType(), ((ListType)otherType).getElementsType());
    }

    private int compareMapType(MapType<?, ?> type, MapType<?, ?> otherType) {
        int test = this.compare(type.getKeysType(), otherType.getKeysType());
        return test != 0 ? test : this.compare(type.getValuesType(), otherType.getValuesType());
    }

    private int compareUserType(UserType type, UserType otherType) {
        return this.compareTuple(type, otherType);
    }

    private int compareTuple(TupleType type, TupleType otherType) {
        if (type.size() != otherType.size()) {
            return Integer.compare(type.size(), otherType.size());
        }
        int test = 0;
        for (int i = 0; test == 0 && i < type.size(); ++i) {
            test = this.compare(type.type(i), otherType.type(i));
        }
        return test;
    }
}

