/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.FloatArray;
import java.util.Arrays;
import phase.LowFreqPhaseIbs;
import phase.LowFreqPhaseStates;
import phase.PhaseData;

public class HmmStateProbs {
    private final PhaseData phaseData;
    private final LowFreqPhaseStates states;
    private final FloatArray pRecomb;
    private final byte[][] mismatch;
    private final float[] bwd;
    private final float[] pMismatch;

    public HmmStateProbs(LowFreqPhaseIbs lowFreqPhaseIbs) {
        this.phaseData = lowFreqPhaseIbs.phaseData();
        int n = this.phaseData.fpd().stage1TargGT().nMarkers();
        int n2 = this.phaseData.fpd().par().phase_states() / 2;
        this.states = new LowFreqPhaseStates(lowFreqPhaseIbs, n2);
        this.pRecomb = this.phaseData.pRecomb();
        this.mismatch = new byte[n][n2];
        this.bwd = new float[n2];
        float f = this.phaseData.pMismatch();
        this.pMismatch = new float[]{1.0f - f, f};
    }

    public int run(int n, int[][] nArray, float[][] fArray) {
        int n2 = this.states.ibsStates(n, nArray, this.mismatch);
        this.runFwd(fArray, n2);
        this.runBwd(fArray, n2);
        return n2;
    }

    private void runFwd(float[][] fArray, int n) {
        int n2;
        float f = 0.0f;
        for (n2 = 0; n2 < n; ++n2) {
            fArray[0][n2] = this.pMismatch[this.mismatch[0][n2]];
            f += fArray[0][n2];
        }
        for (n2 = 1; n2 < fArray.length; ++n2) {
            int n3 = n2 - 1;
            float f2 = this.pRecomb.get(n2);
            float f3 = f2 / (float)n;
            float f4 = (1.0f - f2) / f;
            f = 0.0f;
            for (int i = 0; i < n; ++i) {
                float f5 = this.pMismatch[this.mismatch[n2][i]];
                fArray[n2][i] = f5 * (f4 * fArray[n3][i] + f3);
                f += fArray[n2][i];
            }
        }
    }

    private void runBwd(float[][] fArray, int n) {
        int n2 = fArray.length - 1;
        Arrays.fill(this.bwd, 0, n, 1.0f / (float)n);
        for (int i = n2 - 1; i >= 0; --i) {
            int n3;
            int n4 = i + 1;
            float f = 0.0f;
            for (int j = 0; j < n; ++j) {
                int n5 = j;
                this.bwd[n5] = this.bwd[n5] * this.pMismatch[this.mismatch[n4][j]];
                f += this.bwd[j];
            }
            float f2 = this.pRecomb.get(n4);
            float f3 = (1.0f - f2) / f;
            float f4 = f2 / (float)n;
            f = 0.0f;
            for (n3 = 0; n3 < n; ++n3) {
                this.bwd[n3] = f3 * this.bwd[n3] + f4;
                float[] fArray2 = fArray[i];
                int n6 = n3;
                fArray2[n6] = fArray2[n6] * this.bwd[n3];
                f += fArray[i][n3];
            }
            n3 = 0;
            while (n3 < n) {
                float[] fArray3 = fArray[i];
                int n7 = n3++;
                fArray3[n7] = fArray3[n7] / f;
            }
        }
    }

    public int nMarkers() {
        return this.mismatch.length;
    }

    public int nTargHaps() {
        return this.phaseData.fpd().targGT().nHaps();
    }

    public int maxStates() {
        return this.bwd.length;
    }
}

