/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class ColumnInfoRecord
extends StandardRecord {
    public static final short sid = 125;
    private int field_1_first_col;
    private int field_2_last_col;
    private int field_3_col_width;
    private int field_4_xf_index;
    private int field_5_options;
    private static final BitField hidden = BitFieldFactory.getInstance(1);
    private static final BitField outlevel = BitFieldFactory.getInstance(1792);
    private static final BitField collapsed = BitFieldFactory.getInstance(4096);
    private int field_6_reserved;

    public ColumnInfoRecord() {
        this.setColumnWidth(2275);
        this.field_5_options = 2;
        this.field_4_xf_index = 15;
        this.field_6_reserved = 2;
    }

    public ColumnInfoRecord(RecordInputStream in) {
        this.field_1_first_col = in.readUShort();
        this.field_2_last_col = in.readUShort();
        this.field_3_col_width = in.readUShort();
        this.field_4_xf_index = in.readUShort();
        this.field_5_options = in.readUShort();
        switch (in.remaining()) {
            case 2: {
                this.field_6_reserved = in.readUShort();
                break;
            }
            case 1: {
                this.field_6_reserved = in.readByte();
                break;
            }
            default: {
                throw new RuntimeException("Unusual record size remaining=(" + in.remaining() + ")");
            }
        }
    }

    public void setFirstColumn(int fc) {
        this.field_1_first_col = fc;
    }

    public void setLastColumn(int lc) {
        this.field_2_last_col = lc;
    }

    public void setColumnWidth(int cw) {
        this.field_3_col_width = cw;
    }

    public void setXFIndex(int xfi) {
        this.field_4_xf_index = xfi;
    }

    public void setHidden(boolean ishidden) {
        this.field_5_options = hidden.setBoolean(this.field_5_options, ishidden);
    }

    public void setOutlineLevel(int olevel) {
        this.field_5_options = outlevel.setValue(this.field_5_options, olevel);
    }

    public void setCollapsed(boolean iscollapsed) {
        this.field_5_options = collapsed.setBoolean(this.field_5_options, iscollapsed);
    }

    public int getFirstColumn() {
        return this.field_1_first_col;
    }

    public int getLastColumn() {
        return this.field_2_last_col;
    }

    public int getColumnWidth() {
        return this.field_3_col_width;
    }

    public int getXFIndex() {
        return this.field_4_xf_index;
    }

    public int getOptions() {
        return this.field_5_options;
    }

    public void setOptions(int field_5_options) {
        this.field_5_options = field_5_options;
    }

    public boolean getHidden() {
        return hidden.isSet(this.field_5_options);
    }

    public int getOutlineLevel() {
        return outlevel.getValue(this.field_5_options);
    }

    public boolean getCollapsed() {
        return collapsed.isSet(this.field_5_options);
    }

    public boolean containsColumn(int columnIndex) {
        return this.field_1_first_col <= columnIndex && columnIndex <= this.field_2_last_col;
    }

    public boolean isAdjacentBefore(ColumnInfoRecord other) {
        return this.field_2_last_col == other.field_1_first_col - 1;
    }

    public boolean formatMatches(ColumnInfoRecord other) {
        if (this.field_4_xf_index != other.field_4_xf_index) {
            return false;
        }
        if (this.field_5_options != other.field_5_options) {
            return false;
        }
        return this.field_3_col_width == other.field_3_col_width;
    }

    public short getSid() {
        return 125;
    }

    public void serialize(LittleEndianOutput out) {
        out.writeShort(this.getFirstColumn());
        out.writeShort(this.getLastColumn());
        out.writeShort(this.getColumnWidth());
        out.writeShort(this.getXFIndex());
        out.writeShort(this.field_5_options);
        out.writeShort(this.field_6_reserved);
    }

    protected int getDataSize() {
        return 12;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[COLINFO]\n");
        sb.append("  colfirst = ").append(this.getFirstColumn()).append("\n");
        sb.append("  collast  = ").append(this.getLastColumn()).append("\n");
        sb.append("  colwidth = ").append(this.getColumnWidth()).append("\n");
        sb.append("  xfindex  = ").append(this.getXFIndex()).append("\n");
        sb.append("  options  = ").append(HexDump.shortToHex(this.field_5_options)).append("\n");
        sb.append("    hidden   = ").append(this.getHidden()).append("\n");
        sb.append("    olevel   = ").append(this.getOutlineLevel()).append("\n");
        sb.append("    collapsed= ").append(this.getCollapsed()).append("\n");
        sb.append("[/COLINFO]\n");
        return sb.toString();
    }

    public Object clone() {
        ColumnInfoRecord rec = new ColumnInfoRecord();
        rec.field_1_first_col = this.field_1_first_col;
        rec.field_2_last_col = this.field_2_last_col;
        rec.field_3_col_width = this.field_3_col_width;
        rec.field_4_xf_index = this.field_4_xf_index;
        rec.field_5_options = this.field_5_options;
        rec.field_6_reserved = this.field_6_reserved;
        return rec;
    }
}

