/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.tail.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.trie4j.tail.index.SBVTailIndex;
import org.trie4j.tail.index.TailIndex;
import org.trie4j.tail.index.TailIndexBuilder;
import org.trie4j.util.FastBitSet;

public class SBVTailIndexBuilder
implements Externalizable,
TailIndexBuilder {
    private int current;
    private FastBitSet bs;
    private static final long serialVersionUID = 8843853578097509573L;

    public SBVTailIndexBuilder() {
        this.bs = new FastBitSet();
    }

    public SBVTailIndexBuilder(int initialCapacity) {
        this.bs = new FastBitSet(initialCapacity);
    }

    @Override
    public void add(int nodeId, int start, int end) {
        if (nodeId != this.current) {
            throw new IllegalArgumentException("nodeId must be a strictly increasing.");
        }
        int index = this.bs.size();
        for (int i = start; i < end; ++i) {
            this.bs.set(index++);
        }
        this.bs.unsetIfLE(index);
        ++this.current;
    }

    @Override
    public void addEmpty(int nodeId) {
        if (nodeId != this.current) {
            throw new IllegalArgumentException("nodeId must be a strictly increasing.");
        }
        this.bs.unsetIfLE(this.bs.size());
        ++this.current;
    }

    @Override
    public void trimToSize() {
        this.bs.trimToSize();
    }

    @Override
    public TailIndex build() {
        return new SBVTailIndex(this.bs.getBytes(), this.bs.size(), this.current);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        this.bs = (FastBitSet)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.bs);
    }
}

