/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2.gui;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.table.AbstractTableModel;
import org.omegat.core.team2.TeamSettings;
import org.omegat.core.team2.gui.RepositoriesCredentialsPanel;
import org.omegat.gui.preferences.BasePreferencesController;
import org.omegat.util.OStrings;

public class RepositoriesCredentialsController
extends BasePreferencesController {
    private static final int MAX_ROW_COUNT = 10;
    private RepositoriesCredentialsPanel dialog;

    @Override
    public JComponent getGui() {
        if (this.dialog == null) {
            this.initGui();
            this.initFromPrefs();
        }
        return this.dialog;
    }

    @Override
    public String toString() {
        return OStrings.getString("TEAM_REPOSITORIES_DIALOG");
    }

    private void initGui() {
        this.dialog = new RepositoriesCredentialsPanel();
        this.dialog.list.getSelectionModel().addListSelectionListener(e -> this.dialog.btnRemove.setEnabled(this.dialog.list.getSelectedRow() != -1));
        this.dialog.btnRemove.addActionListener(e -> this.removeSelected());
        Dimension tableSize = this.dialog.list.getPreferredSize();
        this.dialog.list.setPreferredScrollableViewportSize(new Dimension(tableSize.width, this.dialog.list.getRowHeight() * 10));
    }

    @Override
    public void initFromPrefs() {
        TreeSet<String> urls = new TreeSet<String>();
        for (Object o : TeamSettings.listKeys()) {
            String key = o.toString();
            int p = key.lastIndexOf(33);
            if (p <= 0) continue;
            urls.add(key.substring(0, p));
        }
        this.dialog.list.setModel(new Model(urls));
    }

    @Override
    public void restoreDefaults() {
    }

    private void removeSelected() {
        int selectedIndex = this.dialog.list.getSelectedRow();
        if (selectedIndex < 0) {
            return;
        }
        Model model = (Model)this.dialog.list.getModel();
        String selected = model.lines.get(selectedIndex);
        for (Object o : TeamSettings.listKeys()) {
            String key = o.toString();
            if (!key.startsWith(selected + "!")) continue;
            TeamSettings.set(key, null);
        }
        model.lines.remove(selected);
        model.fireTableDataChanged();
    }

    @Override
    public void persist() {
    }

    static class Model
    extends AbstractTableModel {
        List<String> lines;

        Model(Set<String> urls) {
            this.lines = new ArrayList<String>(urls);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.lines.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.lines.get(row);
        }
    }
}

