/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.uk;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.tagging.uk.IPOSTag;

public class SimpleReplaceRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceRule.load((String)"/uk/replace.txt");

    protected Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceRule(ResourceBundle messages) throws IOException {
        super(messages);
        this.setIgnoreTaggedWords();
    }

    public final String getId() {
        return "UK_SIMPLE_REPLACE";
    }

    public String getDescription() {
        return "\u041f\u043e\u0448\u0443\u043a \u043f\u043e\u043c\u0438\u043b\u043a\u043e\u0432\u0438\u0445 \u0441\u043b\u0456\u0432";
    }

    public String getShort() {
        return "\u041f\u043e\u043c\u0438\u043b\u043a\u0430?";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return tokenStr + " - \u043f\u043e\u043c\u0438\u043b\u043a\u043e\u0432\u0435 \u0441\u043b\u043e\u0432\u043e, \u0432\u0438\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u044f: " + StringUtils.join(replacements, (String)", ") + ".";
    }

    protected boolean isTagged(AnalyzedTokenReadings tokenReadings) {
        for (AnalyzedToken token : tokenReadings.getReadings()) {
            String posTag = token.getPOSTag();
            if (!this.isGoodPosTag(posTag)) continue;
            return true;
        }
        return false;
    }

    private boolean isGoodPosTag(String posTag) {
        return posTag != null && !"PARA_END".equals(posTag) && !"SENT_END".equals(posTag) && !posTag.contains(IPOSTag.bad.getText());
    }

    public boolean isCaseSensitive() {
        return false;
    }
}

