/*
 * Decompiled with CFR 0.152.
 */
package io.github.eb4j.dsl;

import io.github.eb4j.dsl.DslDictionary;
import io.github.eb4j.dsl.data.DictionaryData;
import io.github.eb4j.dsl.data.DslDictionaryProperty;
import io.github.eb4j.dsl.data.DslEntry;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import org.dict.zip.RandomAccessInputStream;

public class DslFileDictionary
extends DslDictionary {
    private final RandomAccessInputStream ras;

    public DslFileDictionary(Path path, DictionaryData<DslEntry> dictionaryData, DslDictionaryProperty prop) throws IOException {
        super(dictionaryData, prop);
        this.ras = new RandomAccessInputStream(new RandomAccessFile(path.toFile(), "r"));
    }

    @Override
    String getRecord(long offset, int size) throws IOException {
        byte[] buf = new byte[size];
        this.ras.seek(offset);
        this.ras.readFully(buf);
        return new String(buf, this.prop.getCharset());
    }
}

